<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class AppNameMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (Auth::user() && ! Auth::user()->hasRole('Super Admin')) {
            config(['app.name' => getAppName()]);
        } else {
            config(['app.name' => getSuperAdminAppName()]);
        }

        return $next($request);
    }
}
