/*!
 *  Lang.js for Laravel localization in JavaScript.
 *
 *  @version 1.1.10
 *  @license MIT https://github.com/rmariuzzo/Lang.js/blob/master/LICENSE
 *  @site    https://github.com/rmariuzzo/Lang.js
 *  @author  Rubens Mariuzzo <rubens@mariuzzo.com>
 */
(function(root,factory){"use strict";if(typeof define==="function"&&define.amd){define([],factory)}else if(typeof exports==="object"){module.exports=factory()}else{root.Lang=factory()}})(this,function(){"use strict";function inferLocale(){if(typeof document!=="undefined"&&document.documentElement){return document.documentElement.lang}}function convertNumber(str){if(str==="-Inf"){return-Infinity}else if(str==="+Inf"||str==="Inf"||str==="*"){return Infinity}return parseInt(str,10)}var intervalRegexp=/^({\s*(\-?\d+(\.\d+)?[\s*,\s*\-?\d+(\.\d+)?]*)\s*})|([\[\]])\s*(-Inf|\*|\-?\d+(\.\d+)?)\s*,\s*(\+?Inf|\*|\-?\d+(\.\d+)?)\s*([\[\]])$/;var anyIntervalRegexp=/({\s*(\-?\d+(\.\d+)?[\s*,\s*\-?\d+(\.\d+)?]*)\s*})|([\[\]])\s*(-Inf|\*|\-?\d+(\.\d+)?)\s*,\s*(\+?Inf|\*|\-?\d+(\.\d+)?)\s*([\[\]])/;var defaults={locale:"en"};var Lang=function(options){options=options||{};this.locale=options.locale||inferLocale()||defaults.locale;this.fallback=options.fallback;this.messages=options.messages};Lang.prototype.setMessages=function(messages){this.messages=messages};Lang.prototype.getLocale=function(){return this.locale||this.fallback};Lang.prototype.setLocale=function(locale){this.locale=locale};Lang.prototype.getFallback=function(){return this.fallback};Lang.prototype.setFallback=function(fallback){this.fallback=fallback};Lang.prototype.has=function(key,locale){if(typeof key!=="string"||!this.messages){return false}return this._getMessage(key,locale)!==null};Lang.prototype.get=function(key,replacements,locale){if(!this.has(key,locale)){return key}var message=this._getMessage(key,locale);if(message===null){return key}if(replacements){message=this._applyReplacements(message,replacements)}return message};Lang.prototype.trans=function(key,replacements){return this.get(key,replacements)};Lang.prototype.choice=function(key,number,replacements,locale){replacements=typeof replacements!=="undefined"?replacements:{};replacements.count=number;var message=this.get(key,replacements,locale);if(message===null||message===undefined){return message}var messageParts=message.split("|");var explicitRules=[];for(var i=0;i<messageParts.length;i++){messageParts[i]=messageParts[i].trim();if(anyIntervalRegexp.test(messageParts[i])){var messageSpaceSplit=messageParts[i].split(/\s/);explicitRules.push(messageSpaceSplit.shift());messageParts[i]=messageSpaceSplit.join(" ")}}if(messageParts.length===1){return message}for(var j=0;j<explicitRules.length;j++){if(this._testInterval(number,explicitRules[j])){return messageParts[j]}}var pluralForm=this._getPluralForm(number);return messageParts[pluralForm]};Lang.prototype.transChoice=function(key,count,replacements){return this.choice(key,count,replacements)};Lang.prototype._parseKey=function(key,locale){if(typeof key!=="string"||typeof locale!=="string"){return null}var segments=key.split(".");var source=segments[0].replace(/\//g,".");return{source:locale+"."+source,sourceFallback:this.getFallback()+"."+source,entries:segments.slice(1)}};Lang.prototype._getMessage=function(key,locale){locale=locale||this.getLocale();key=this._parseKey(key,locale);if(this.messages[key.source]===undefined&&this.messages[key.sourceFallback]===undefined){return null}var message=this.messages[key.source];var entries=key.entries.slice();var subKey="";while(entries.length&&message!==undefined){var subKey=!subKey?entries.shift():subKey.concat(".",entries.shift());if(message[subKey]!==undefined){message=message[subKey];subKey=""}}if(typeof message!=="string"&&this.messages[key.sourceFallback]){message=this.messages[key.sourceFallback];entries=key.entries.slice();subKey="";while(entries.length&&message!==undefined){var subKey=!subKey?entries.shift():subKey.concat(".",entries.shift());if(message[subKey]){message=message[subKey];subKey=""}}}if(typeof message!=="string"){return null}return message};Lang.prototype._findMessageInTree=function(pathSegments,tree){while(pathSegments.length&&tree!==undefined){var dottedKey=pathSegments.join(".");if(tree[dottedKey]){tree=tree[dottedKey];break}tree=tree[pathSegments.shift()]}return tree};Lang.prototype._applyReplacements=function(message,replacements){for(var replace in replacements){message=message.replace(new RegExp(":"+replace,"gi"),function(match){var value=replacements[replace];var allCaps=match===match.toUpperCase();if(allCaps){return value.toUpperCase()}var firstCap=match===match.replace(/\w/i,function(letter){return letter.toUpperCase()});if(firstCap){return value.charAt(0).toUpperCase()+value.slice(1)}return value})}return message};Lang.prototype._testInterval=function(count,interval){if(typeof interval!=="string"){throw"Invalid interval: should be a string."}interval=interval.trim();var matches=interval.match(intervalRegexp);if(!matches){throw"Invalid interval: "+interval}if(matches[2]){var items=matches[2].split(",");for(var i=0;i<items.length;i++){if(parseInt(items[i],10)===count){return true}}}else{matches=matches.filter(function(match){return!!match});var leftDelimiter=matches[1];var leftNumber=convertNumber(matches[2]);if(leftNumber===Infinity){leftNumber=-Infinity}var rightNumber=convertNumber(matches[3]);var rightDelimiter=matches[4];return(leftDelimiter==="["?count>=leftNumber:count>leftNumber)&&(rightDelimiter==="]"?count<=rightNumber:count<rightNumber)}return false};Lang.prototype._getPluralForm=function(count){switch(this.locale){case"az":case"bo":case"dz":case"id":case"ja":case"jv":case"ka":case"km":case"kn":case"ko":case"ms":case"th":case"tr":case"vi":case"zh":return 0;case"af":case"bn":case"bg":case"ca":case"da":case"de":case"el":case"en":case"eo":case"es":case"et":case"eu":case"fa":case"fi":case"fo":case"fur":case"fy":case"gl":case"gu":case"ha":case"he":case"hu":case"is":case"it":case"ku":case"lb":case"ml":case"mn":case"mr":case"nah":case"nb":case"ne":case"nl":case"nn":case"no":case"om":case"or":case"pa":case"pap":case"ps":case"pt":case"so":case"sq":case"sv":case"sw":case"ta":case"te":case"tk":case"ur":case"zu":return count==1?0:1;case"am":case"bh":case"fil":case"fr":case"gun":case"hi":case"hy":case"ln":case"mg":case"nso":case"xbr":case"ti":case"wa":return count===0||count===1?0:1;case"be":case"bs":case"hr":case"ru":case"sr":case"uk":return count%10==1&&count%100!=11?0:count%10>=2&&count%10<=4&&(count%100<10||count%100>=20)?1:2;case"cs":case"sk":return count==1?0:count>=2&&count<=4?1:2;case"ga":return count==1?0:count==2?1:2;case"lt":return count%10==1&&count%100!=11?0:count%10>=2&&(count%100<10||count%100>=20)?1:2;case"sl":return count%100==1?0:count%100==2?1:count%100==3||count%100==4?2:3;case"mk":return count%10==1?0:1;case"mt":return count==1?0:count===0||count%100>1&&count%100<11?1:count%100>10&&count%100<20?2:3;case"lv":return count===0?0:count%10==1&&count%100!=11?1:2;case"pl":return count==1?0:count%10>=2&&count%10<=4&&(count%100<12||count%100>14)?1:2;case"cy":return count==1?0:count==2?1:count==8||count==11?2:3;case"ro":return count==1?0:count===0||count%100>0&&count%100<20?1:2;case"ar":return count===0?0:count==1?1:count==2?2:count%100>=3&&count%100<=10?3:count%100>=11&&count%100<=99?4:5;default:return 0}};return Lang});

(function () {
    Lang = new Lang();
    Lang.setMessages({"ar.js":{"about_us_description":"\u0648\u0635\u0641","about_us_mission":"\u0645\u0647\u0645\u0629","about_us_title":"\u0639\u0646\u0648\u0627\u0646","active":"\u0646\u0634\u064a\u0637","all_notification_read":"\u062a\u0645\u062a \u0642\u0631\u0627\u0621\u0629 \u0643\u0627\u0641\u0629 \u0627\u0644\u0625\u062e\u0637\u0627\u0631\u0627\u062a \u0628\u0646\u062c\u0627\u062d.","all_required_fields":"\u064a\u0631\u062c\u0649 \u0645\u0644\u0621 \u0643\u0627\u0641\u0629 \u0627\u0644\u062d\u0642\u0648\u0644 \u0627\u0644\u0645\u0637\u0644\u0648\u0628\u0629.","apply":"\u064a\u062a\u0642\u062f\u0645","appointment":"\u0645\u064a\u0639\u0627\u062f","appointment_cancel":"\u062a\u0645 \u0625\u0644\u063a\u0627\u0621 \u0627\u0644\u0645\u0648\u0639\u062f \u0628\u0646\u062c\u0627\u062d.","apr":"\u0623\u0628\u0631\u064a\u0644","are_u_sure":"\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f\u061f","are_you_sure_want_to_cancel":"\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u063a\u0627\u0621","are_you_sure_want_to_change":"\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u0627\u0644\u062a\u063a\u064a\u064a\u0631","are_you_sure_want_to_delete_this":"\u0647\u0644 \u062a\u0631\u064a\u062f \u0628\u0627\u0644\u062a\u0623\u0643\u064a\u062f \u062d\u0630\u0641 \u0647\u0630\u0627","are_you_sure_want_to_return_this_item":"\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u0625\u0631\u062c\u0627\u0639 \u0647\u0630\u0627 \u0627\u0644\u0639\u0646\u0635\u0631","aug":"\u0623\u063a\u0633\u0637\u0633","available_quantity":"\u0627\u0644\u0643\u0645\u064a\u0629 \u0627\u0644\u0645\u062a\u0648\u0641\u0631\u0629","break_time_greater_than_zero":"\u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0648\u0642\u062a \u0627\u0644\u0627\u0633\u062a\u0631\u0627\u062d\u0629 \u0623\u0643\u0628\u0631 \u0645\u0646 \u0627\u0644\u0635\u0641\u0631","break_to_time_greater_than_from_time":"\u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0648\u0642\u062a \u0627\u0644\u0627\u0633\u062a\u0631\u0627\u062d\u0629 \u0623\u0643\u0628\u0631 \u0645\u0646 \u0648\u0642\u062a \u0627\u0644\u0627\u0633\u062a\u0631\u0627\u062d\u0629.","break_to_time_greater_than_zero":"\u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0648\u0642\u062a \u0627\u0644\u0627\u0633\u062a\u0631\u0627\u062d\u0629 \u0623\u0643\u0628\u0631 \u0645\u0646 \u0627\u0644\u0635\u0641\u0631","cancel":"\u064a\u0644\u063a\u064a","canceled":"\u0623\u0644\u063a\u064a\u062a","captcha_key":"\u0645\u0641\u062a\u0627\u062d \u062c\u0648\u062c\u0644 \u0643\u0627\u0628\u062a\u0634\u0627","captcha_secret":"\u0633\u0631 \u062c\u0648\u062c\u0644 \u0643\u0627\u0628\u062a\u0634\u0627","card_template":"\u0646\u0645\u0648\u0630\u062c \u0627\u0644\u0628\u0637\u0627\u0642\u0629 \u0627\u0644\u0630\u0643\u064a\u0629 \u0644\u0644\u0645\u0631\u064a\u0636","change_status":"\u062a\u063a\u064a\u064a\u0631 \u0627\u0644\u0648\u0636\u0639","changed_appointment":"\u062a\u0645 \u062a\u063a\u064a\u064a\u0631 \u0627\u0644\u0645\u0648\u0639\u062f","charchter_160":"\u0644\u0627 \u064a\u062c\u0648\u0632 \u0623\u0646 \u062a\u0632\u064a\u062f \u0627\u0644\u0631\u0633\u0627\u0644\u0629 \u0639\u0646 160 \u062d\u0631\u0641\u064b\u0627.","choose_bed":"\u0627\u062e\u062a\u0631 \u0627\u0644\u0633\u0631\u064a\u0631","choose_case":"\u0627\u062e\u062a\u0631 \u0627\u0644\u062d\u0627\u0644\u0629","currency":"\u0639\u0645\u0644\u0629","custom":"\u0645\u062e\u0635\u0635","date_required":"\u062d\u0642\u0644 \u0627\u0644\u062a\u0627\u0631\u064a\u062e \u0645\u0637\u0644\u0648\u0628","deactive":"\u063a\u064a\u0631 \u0646\u0634\u0637","dec":"\u062f\u064a\u0633\u0645\u0628\u0631","deduction_not_greater_than_salary":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0627\u0633\u062a\u0642\u0637\u0627\u0639\u0627\u062a \u0623\u0643\u0628\u0631 \u0645\u0646 \u0627\u0644\u0631\u0627\u062a\u0628 \u0627\u0644\u0623\u0633\u0627\u0633\u064a + \u0627\u0644\u0639\u0644\u0627\u0648\u0629","deleted":"\u062a\u0645 \u0627\u0644\u062d\u0630\u0641","department":"\u0642\u0633\u0645","disconnect_or_reconnect":"\u064a\u0631\u062c\u0649 \u0642\u0637\u0639 \u0627\u0644\u0627\u062a\u0635\u0627\u0644 \u0648\u0625\u0639\u0627\u062f\u0629 \u062a\u0648\u0635\u064a\u0644 \u062a\u0642\u0648\u064a\u0645 Google \u0627\u0644\u062e\u0627\u0635 \u0628\u0643","discount_less_than_amount":"\u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u062e\u0635\u0645 \u0623\u0642\u0644 \u0645\u0646 \u0627\u0644\u0645\u0628\u0644\u063a \u0627\u0644\u0625\u062c\u0645\u0627\u0644\u064a.","doctor_schedule_not_available_on_this_date":"\u062c\u062f\u0648\u0644 \u0627\u0644\u0637\u0628\u064a\u0628 \u063a\u064a\u0631 \u0645\u062a\u0627\u062d \u0647\u0630\u0627 \u0627\u0644\u062a\u0627\u0631\u064a\u062e.","document_file_size":"\u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u0645\u0633\u062a\u0646\u062f \u0645\u0644\u0641\u064b\u0627 \u0645\u0646 \u0627\u0644\u0646\u0648\u0639: jpeg\u060c jpg\u060c png\u060c pdf\u060c doc\u060c docx.\u060c mp3\u060c mp4","document_must_be_file_type":"\u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u0645\u0633\u062a\u0646\u062f \u0645\u0644\u0641\u064b\u0627 \u0645\u0646 \u0627\u0644\u0646\u0648\u0639: jpeg\u060c jpg\u060c png\u060c pdf\u060c doc\u060c docx.","enter_lot_no":"\u0623\u062f\u062e\u0644 \u0631\u0642\u0645 \u0627\u0644\u0642\u0637\u0639\u0629.","enter_purchase_price":"\u0623\u062f\u062e\u0644 \u0633\u0639\u0631 \u0627\u0644\u0634\u0631\u0627\u0621.","enter_sale_price":"\u0623\u062f\u062e\u0644 \u0633\u0639\u0631 \u0627\u0644\u0628\u064a\u0639.","feb":"\u0634\u0647\u0631 \u0641\u0628\u0631\u0627\u064a\u0631","field_not_contain_white_space":"\u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u0627\u0644\u062d\u0642\u0644 \u0639\u0644\u0649 \u0645\u0633\u0627\u062d\u0629 \u0628\u064a\u0636\u0627\u0621 \u0641\u0642\u0637","field_required":"\u0627\u0644\u062d\u0642\u0644 \u0645\u0637\u0644\u0648\u0628.","fri":"\u0627\u0644\u062c\u0645\u0639\u0629","friday":"\u062c\u0645\u0639\u0629","from":"\u0645\u0646","google_meet":"\u062c\u0648\u062c\u0644 \u0645\u064a\u062a","has_been_changed":"\u062a\u063a\u064a\u0631.","has_been_deleted":"\u0642\u062f \u062a\u0645 \u062d\u0630\u0641.","holiday":"\u0639\u0637\u0644\u0629","home_page_box_description":"\u0648\u0635\u0641 \u0645\u0631\u0628\u0639 \u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629","home_page_box_title":"\u0639\u0646\u0648\u0627\u0646 \u0645\u0631\u0628\u0639 \u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629","home_page_certified_box_description":"\u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u0648\u0635\u0641 \u0627\u0644\u0635\u0646\u062f\u0648\u0642 \u0627\u0644\u0645\u0639\u062a\u0645\u062f","home_page_certified_box_title":"\u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0635\u0646\u062f\u0648\u0642 \u0627\u0644\u0645\u0639\u062a\u0645\u062f","home_page_certified_doctor_description":"\u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u0648\u0635\u0641 \u0627\u0644\u0637\u0628\u064a\u0628 \u0627\u0644\u0645\u0639\u062a\u0645\u062f","home_page_certified_doctor_text":"\u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u0646\u0635 \u0637\u0628\u064a\u0628 \u0645\u0639\u062a\u0645\u062f","home_page_certified_doctor_title":"\u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0637\u0628\u064a\u0628 \u0627\u0644\u0645\u0639\u062a\u0645\u062f","home_page_description":"\u0648\u0635\u0641 \u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629","home_page_experience":"\u062a\u062c\u0631\u0628\u0629 \u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629","home_page_step_1_description":"\u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u0648\u0635\u0641 \u0627\u0644\u062e\u0637\u0648\u0629 1","home_page_step_1_title":"\u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u0627\u0644\u062e\u0637\u0648\u0629 1 \u0627\u0644\u0639\u0646\u0648\u0627\u0646","home_page_step_2_description":"\u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u0627\u0644\u062e\u0637\u0648\u0629 2 \u0627\u0644\u0648\u0635\u0641","home_page_step_2_title":"\u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u0627\u0644\u062e\u0637\u0648\u0629 2 \u0627\u0644\u0639\u0646\u0648\u0627\u0646","home_page_step_3_description":"\u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u0627\u0644\u062e\u0637\u0648\u0629 3 \u0627\u0644\u0648\u0635\u0641","home_page_step_3_title":"\u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u0627\u0644\u062e\u0637\u0648\u0629 3 \u0627\u0644\u0639\u0646\u0648\u0627\u0646","home_page_step_4_description":"\u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u0648\u0635\u0641 \u0627\u0644\u062e\u0637\u0648\u0629 4","home_page_step_4_title":"\u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u0627\u0644\u062e\u0637\u0648\u0629 4 \u0627\u0644\u0639\u0646\u0648\u0627\u0646","home_page_title":"\u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629","image_must_be":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0635\u0648\u0631\u0629 \u0645\u0644\u0641\u064b\u0627 \u0645\u0646 \u0627\u0644\u0646\u0648\u0639: jpg\u060c jpeg\u060c png.","invalid_country_code":"\u0631\u0645\u0632 \u0627\u0644\u0628\u0644\u062f \u063a\u064a\u0631 \u0635\u0627\u0644\u062d","invalid_number":"\u0631\u0642\u0645 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d","ipd_timeline":"IPD \u0627\u0644\u062c\u062f\u0648\u0644 \u0627\u0644\u0632\u0645\u0646\u064a","item_returned":"\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u0625\u0631\u062c\u0627\u0639 \u0647\u0630\u0627 \u0627\u0644\u0639\u0646\u0635\u0631","jan":"\u064a\u0646\u0627\u064a\u0631","jul":"\u064a\u0648\u0644\u064a\u0648","jun":"\u064a\u0648\u0646\u064a\u0648","last_30_days":"\u0622\u062e\u0631 30 \u064a\u0648\u0645\u064b\u0627","last_7_days":"\u0627\u062e\u0631 7 \u0627\u064a\u0627\u0645","last_month":"\u0627\u0644\u0634\u0647\u0631 \u0627\u0644\u0645\u0627\u0636\u064a","lunch_break":"\u0627\u0633\u062a\u0631\u0627\u062d\u0629","mar":"\u064a\u0645\u0634\u064a","may":"\u064a\u0645\u0643\u0646","medicine_bill":"\u0641\u0627\u062a\u0648\u0631\u0629 \u0627\u0644\u0637\u0628","medicine_bill_already_use":"\u0647\u0630\u0627 \u0627\u0644\u062f\u0648\u0627\u0621 \u0645\u0633\u062a\u062e\u062f\u0645 \u0628\u0627\u0644\u0641\u0639\u0644 \u0641\u064a \u0641\u0648\u0627\u062a\u064a\u0631 \u0627\u0644\u0623\u062f\u0648\u064a\u0629\u060c \u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0645\u0646 \u0631\u063a\u0628\u062a\u0643 \u0641\u064a \u062d\u0630\u0641\u0647\u061f","medicine_required":"\u0645\u0637\u0644\u0648\u0628 \u0645\u062c\u0627\u0644 \u0627\u0644\u0637\u0628.","mon":"\u0645\u0648\u0646","monday":"\u0627\u0644\u0623\u062d\u062f","net_amount_not_empty":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u0645\u0628\u0644\u063a \u0627\u0644\u0635\u0627\u0641\u064a \u0641\u0627\u0631\u063a\u064b\u0627.","net_amount_not_zero":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u0645\u0628\u0644\u063a \u0627\u0644\u0635\u0627\u0641\u064a \u0635\u0641\u0631\u0627\u064b.","no_ipd_patient_found":"\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0645\u0631\u064a\u0636 IPD","notification_read":"\u062a\u0645\u062a \u0642\u0631\u0627\u0621\u0629 \u0627\u0644\u0625\u0634\u0639\u0627\u0631 \u0628\u0646\u062c\u0627\u062d.","nov":"\u0634\u0647\u0631 \u0646\u0648\u0641\u0645\u0628\u0631","oct":"\u0627\u0643\u062a\u0648\u0628\u0631","paid":"\u0645\u062f\u0641\u0648\u0639","password_not_match":"\u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0648\u062a\u0623\u0643\u064a\u062f \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u063a\u064a\u0631 \u0645\u062a\u0637\u0627\u0628\u0642\u064a\u0646.","patient_not_exists_or_status_is_not_active":"\u0627\u0644\u0645\u0631\u064a\u0636 \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f \u0623\u0648 \u0627\u0644\u062d\u0627\u0644\u0629 \u063a\u064a\u0631 \u0646\u0634\u0637\u0629.","patient_required":"\u062d\u0642\u0644 \u0627\u0644\u0645\u0631\u064a\u0636 \u0645\u0637\u0644\u0648\u0628.","paypal_client_id":"\u0645\u0639\u0631\u0641 \u0639\u0645\u064a\u0644 \u0628\u0627\u064a \u0628\u0627\u0644","paypal_mode":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0648\u0636\u0639 \u0628\u0627\u064a \u0628\u0627\u0644.","paypal_secret":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0633\u0631 \u0628\u0627\u064a \u0628\u0627\u0644.","paystack_key":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0645\u0641\u062a\u0627\u062d paystack \u0627\u0644\u0639\u0627\u0645.","paystack_secret":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0645\u0641\u062a\u0627\u062d paystack \u0627\u0644\u0633\u0631\u064a.","paytm_id":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0645\u0639\u0631\u0641 \u0627\u0644\u062a\u0627\u062c\u0631 paytm.","paytm_key":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0645\u0641\u062a\u0627\u062d \u0627\u0644\u062a\u0627\u062c\u0631 paytm.","phone_number":"\u0631\u0642\u0645 \u0627\u0644\u062a\u0644\u064a\u0641\u0648\u0646","please_enter_valid_Instagram_url":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0639\u0646\u0648\u0627\u0646 URL \u0635\u0627\u0644\u062d \u0644\u0640 Instagram","please_enter_valid_facebook_url":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0639\u0646\u0648\u0627\u0646 URL \u0635\u0627\u0644\u062d \u0644\u0644\u0641\u064a\u0633\u0628\u0648\u0643","please_enter_valid_linkedin_url":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0639\u0646\u0648\u0627\u0646 URL \u0635\u0627\u0644\u062d \u0644\u0640 LinkedIn","please_enter_valid_twitter_url":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0639\u0646\u0648\u0627\u0646 URL \u0635\u0627\u0644\u062d \u0644\u062a\u0648\u064a\u062a\u0631","please_select_doctor":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0627\u062e\u062a\u064a\u0627\u0631 \u0627\u0644\u0637\u0628\u064a\u0628","privacy_policy":"\u0633\u064a\u0627\u0633\u0629 \u0627\u0644\u062e\u0635\u0648\u0635\u064a\u0629","purchase_medicine":"\u0634\u0631\u0627\u0621 \u0627\u0644\u0637\u0628","qr_code_not_found":"\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0631\u0645\u0632 \u0627\u0644\u0627\u0633\u062a\u062c\u0627\u0628\u0629 \u0627\u0644\u0633\u0631\u064a\u0639\u0629.","qty_cannot_be_zero":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0643\u0645\u064a\u0629 \u0635\u0641\u0631\u0627\u064b.","qty_must_be_less_than_available_qty":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0643\u0645\u064a\u0629 \u0623\u0642\u0644 \u0645\u0646 \u0627\u0644\u0643\u0645\u064a\u0629 \u0627\u0644\u0645\u062a\u0648\u0641\u0631\u0629.","quantity_greater_than_0":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0643\u0645\u064a\u0629 \u0623\u0643\u0628\u0631 \u0645\u0646 0.","quantity_not_empty":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0643\u0645\u064a\u0629 \u0635\u0641\u0631\u064b\u0627 \u0623\u0648 \u0641\u0627\u0631\u063a\u0629.","razor_pay_secret":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0633\u0631 razorpay.","razorpay_key":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0645\u0641\u062a\u0627\u062d razorpay.","sat":"\u0642\u0639\u062f","saturday":"\u0627\u0644\u0633\u0628\u062a","select_account":"\u062d\u062f\u062f \u062d\u0633\u0627\u0628","select_appointment_date":"\u0627\u0644\u0631\u062c\u0627\u0621 \u062a\u062d\u062f\u064a\u062f \u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0645\u0648\u0639\u062f.","select_bed_type":"\u062d\u062f\u062f \u0646\u0648\u0639 \u0627\u0644\u0633\u0631\u064a\u0631","select_calendar":"\u0627\u0644\u0631\u062c\u0627\u0621 \u062a\u062d\u062f\u064a\u062f \u0627\u0644\u062a\u0642\u0648\u064a\u0645.","select_category":"\u0627\u062e\u062a\u0631 \u0627\u0644\u0641\u0626\u0629","select_charge":"\u062d\u062f\u062f \u0627\u0644\u0634\u062d\u0646","select_charge_category":"\u062d\u062f\u062f \u0641\u0626\u0629 \u0627\u0644\u0634\u062d\u0646","select_charge_type":"\u062d\u062f\u062f \u0646\u0648\u0639 \u0627\u0644\u0641\u0626\u0629","select_code":"\u062d\u062f\u062f \u0627\u0644\u0631\u0645\u0632","select_doctor":"\u0627\u062e\u062a\u0631 \u0627\u0644\u0637\u0628\u064a\u0628","select_doctors":"\u0627\u062e\u062a\u0631 \u0627\u0644\u0623\u0637\u0628\u0627\u0621","select_dose_interval":"\u062d\u062f\u062f \u0627\u0644\u0641\u0627\u0635\u0644 \u0627\u0644\u0632\u0645\u0646\u064a \u0644\u0644\u062c\u0631\u0639\u0629","select_duration":"\u062d\u062f\u062f \u0627\u0644\u0645\u062f\u0629","select_employee":"\u062d\u062f\u062f \u0627\u0644\u0645\u0648\u0638\u0641","select_ipd_patient":"\u062d\u062f\u062f \u0645\u0631\u064a\u0636 IPD","select_item":"\u062d\u062f\u062f \u0627\u0644\u0639\u0646\u0635\u0631","select_medicine":"\u0627\u062e\u062a\u0631 \u0627\u0644\u0637\u0628","select_parameter_name":"\u062d\u062f\u062f \u0627\u0633\u0645 \u0627\u0644\u0645\u0639\u0644\u0645\u0629","select_patient":"\u0627\u062e\u062a\u0631 \u0627\u0644\u0645\u0631\u064a\u0636","select_service":"\u0627\u062e\u062a\u0631 \u0627\u0644\u062e\u062f\u0645\u0629","select_time_slot":"\u0627\u0644\u0631\u062c\u0627\u0621 \u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0641\u062a\u0631\u0629 \u0627\u0644\u0632\u0645\u0646\u064a\u0629 \u0644\u0644\u0645\u0648\u0639\u062f.","select_type_number":"\u062d\u062f\u062f \u0631\u0642\u0645 \u0627\u0644\u0646\u0648\u0639","select_user":"\u0627\u062e\u062a\u0631 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645","send_mail":"\u0627\u0631\u0633\u0644 \u0628\u0631\u064a\u062f","sending":"\u0625\u0631\u0633\u0627\u0644...","sep":"\u0633\u0628\u062a\u0645\u0628\u0631","smart_patient_card":"\u0627\u0644\u0628\u0637\u0627\u0642\u0629 \u0627\u0644\u0630\u0643\u064a\u0629 \u0644\u0644\u0645\u0631\u064a\u0636","status":"\u062d\u0627\u0644\u0629","stripe_key":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0633\u0631 \u0627\u0644\u0634\u0631\u064a\u0637.","stripe_secret":"\u0633\u0631 \u0627\u0644\u0634\u0631\u064a\u0637","sun":"\u0634\u0645\u0633","sunday":"\u0627\u0644\u0623\u062d\u062f","tax_less_100":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0636\u0631\u0627\u0626\u0628 \u0623\u0642\u0644 \u0645\u0646 100%.","tax_not_empty":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0645\u0628\u0644\u063a \u0627\u0644\u0636\u0631\u064a\u0628\u0629 \u0635\u0641\u0631\u064b\u0627 \u0623\u0648 \u0641\u0627\u0631\u063a\u064b\u0627.","template_required":"\u062d\u0642\u0644 \u0627\u0633\u0645 \u0627\u0644\u0642\u0627\u0644\u0628 \u0645\u0637\u0644\u0648\u0628.","terms_condition_required":"\u0627\u0644\u0634\u0631\u0648\u0637 \u0648\u0627\u0644\u0623\u062d\u0643\u0627\u0645 \u0645\u0637\u0644\u0648\u0628\u0629.","terms_conditions":"\u0627\u0644\u0628\u0646\u0648\u062f \u0648 \u0627\u0644\u0638\u0631\u0648\u0641","this_month":"\u0647\u0630\u0627 \u0627\u0644\u0634\u0647\u0631","this_week":"\u0647\u0630\u0627 \u0627\u0644\u0627\u0633\u0628\u0648\u0639","thu":"\u0627\u0644\u062e\u0645\u064a\u0633","thursday":"\u064a\u0648\u0645 \u0627\u0644\u062e\u0645\u064a\u0633","to":"\u0644","today":"\u0627\u0644\u064a\u0648\u0645","too_long":"\u0637\u0648\u064a\u0644 \u062c\u062f\u0627","too_short":"\u0642\u0635\u064a\u0631 \u062c\u062f\u0627","tue":"\u0627\u0644\u062b\u0644\u0627\u062b\u0627\u0621","tuesday":"\u064a\u0648\u0645 \u0627\u0644\u062b\u0644\u0627\u062b\u0627\u0621","u_want_to_complete_this_payment":"\u062a\u0631\u064a\u062f \u0625\u0643\u0645\u0627\u0644 \u0647\u0630\u0647 \u0627\u0644\u062f\u0641\u0639\u0629!","unpaid":"\u063a\u064a\u0631 \u0645\u062f\u0641\u0648\u0639\u0629 \u0627\u0644\u0623\u062c\u0631","update_quantity":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0643\u0645\u064a\u0629 \u0627\u0644\u062a\u062d\u062f\u064a\u062b \u0623\u0642\u0644 \u0645\u0646 \u0627\u0644\u0643\u0645\u064a\u0629 \u0627\u0644\u0633\u0627\u0628\u0642\u0629.","value_field_required":"\u062d\u0642\u0644 \u0627\u0644\u0642\u064a\u0645\u0629 \u0645\u0637\u0644\u0648\u0628.","value_must_be_greter_then":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0642\u064a\u0645\u0629 \u0623\u0643\u0628\u0631 \u0645\u0646 1","warning":"\u062a\u062d\u0630\u064a\u0631 !","wed":"\u062a\u0632\u0648\u062c","wednesday":"\u0627\u0644\u0623\u0631\u0628\u0639\u0627\u0621","yesterday":"\u0623\u0645\u0633","your_payment_failed":"\u0641\u0634\u0644 \u0627\u0644\u062f\u0641\u0639 \u0627\u0644\u062e\u0627\u0635 \u0628\u0643.","zoom":"\u062a\u0643\u0628\u064a\u0631"},"de.js":{"about_us_description":"Beschreibung","about_us_mission":"Mission","about_us_title":"Titel","active":"Aktiv","all_notification_read":"Alle Benachrichtigungen wurden erfolgreich gelesen.","all_required_fields":"Bitte f\u00fcllen Sie alle erforderlichen Felder aus.","apply":"Anwenden","appointment":"Termin","appointment_cancel":"Termin erfolgreich abgesagt.","apr":"April","are_u_sure":"Bist du sicher?","are_you_sure_want_to_cancel":"Sind Sie sicher, dass sie abbrechen wollen","are_you_sure_want_to_change":"M\u00f6chten Sie wirklich etwas \u00e4ndern?","are_you_sure_want_to_delete_this":"M\u00f6chten Sie dies wirklich l\u00f6schen?","are_you_sure_want_to_return_this_item":"M\u00f6chten Sie diesen Artikel wirklich zur\u00fcckgeben?","aug":"August","available_quantity":"verf\u00fcgbare Anzahl","break_time_greater_than_zero":"Die Pausenzeit muss gr\u00f6\u00dfer als Null sein","break_to_time_greater_than_from_time":"Die Pause-bis-Zeit muss gr\u00f6\u00dfer sein als die Pause-von-Zeit.","break_to_time_greater_than_zero":"Die Pausenzeit muss gr\u00f6\u00dfer als Null sein","cancel":"Stornieren","canceled":"Abgesagt","captcha_key":"Google Captcha-Schl\u00fcssel","captcha_secret":"Google Captcha-Geheimnis","card_template":"Patienten-Smartcard-Vorlage","change_status":"Status \u00e4ndern","changed_appointment":"Ge\u00e4nderter Termin","charchter_160":"Die Nachricht darf nicht l\u00e4nger als 160 Zeichen sein.","choose_bed":"W\u00e4hlen Sie Code aus","choose_case":"Konto ausw\u00e4hlen","currency":"W\u00e4hrung","custom":"Brauch","date_required":"Das Datumsfeld ist erforderlich","deactive":"Deaktiviert","dec":"Dezember","deduction_not_greater_than_salary":"Deductions cannot be greater than Basic salary + Allowance","deleted":"Gel\u00f6scht","department":"Abteilung","disconnect_or_reconnect":"Bitte trennen Sie die Verbindung zu Ihrem Google-Kalender und verbinden Sie ihn erneut","discount_less_than_amount":"Der Rabatt sollte geringer sein als der Gesamtbetrag.","doctor_schedule_not_available_on_this_date":"Der Arztterminplan ist an diesem Datum nicht verf\u00fcgbar.","document_file_size":"Das Dokument muss eine Datei des folgenden Typs sein: jpeg, jpg, png, pdf, doc, docx., mp3, mp4","document_must_be_file_type":"Das Dokument muss eine Datei des folgenden Typs sein: jpeg, jpg, png, pdf, doc, docx.","enter_lot_no":"Geben Sie die Chargennummer ein.","enter_purchase_price":"Kaufpreis eingeben.","enter_sale_price":"Geben Sie den Verkaufspreis ein.","feb":"Februar","field_not_contain_white_space":"Das Feld enth\u00e4lt nicht nur Leerzeichen","field_required":"Feld ist erforderlich.","fri":"FR","friday":"Freitag","from":"Aus","google_meet":"Google Meet","has_been_changed":"wurde ge\u00e4ndert.","has_been_deleted":"Ihre Zahlung ist fehlgeschlagen.","holiday":"Urlaub","home_page_box_description":"Beschreibung des Startseitenfelds","home_page_box_title":"Titel der Homepage-Box","home_page_certified_box_description":"Homepage-Beschreibung der zertifizierten Box","home_page_certified_box_title":"Startseite Zertifizierter Boxtitel","home_page_certified_doctor_description":"Startseite Beschreibung des zertifizierten Arztes","home_page_certified_doctor_text":"Homepage-Text f\u00fcr zertifizierte \u00c4rzte","home_page_certified_doctor_title":"Startseite Zertifizierter Arzttitel","home_page_description":"Beschreibung der Startseite","home_page_experience":"Homepage-Erlebnis","home_page_step_1_description":"Startseite Schritt 1 Beschreibung","home_page_step_1_title":"Startseite Schritt 1 Titel","home_page_step_2_description":"Startseite Schritt 2 Beschreibung","home_page_step_2_title":"Startseite Schritt 2 Titel","home_page_step_3_description":"Startseite Schritt 3 Beschreibung","home_page_step_3_title":"Startseite Schritt 3 Titel","home_page_step_4_description":"Startseite Schritt 4 Beschreibung","home_page_step_4_title":"Startseite Schritt 4 Titel","home_page_title":"Titel der Startseite","image_must_be":"Das Bild muss eine Datei des folgenden Typs sein: jpg, jpeg, png.","invalid_country_code":"Ung\u00fcltiger L\u00e4ndercode","invalid_number":"Ung\u00fcltige Nummer","ipd_timeline":"IPD-Zeitleiste","item_returned":"Artikel erfolgreich zur\u00fcckgegeben.","jan":"Januar","jul":"Juli","jun":"Juni","last_30_days":"Letzte 30 Tage","last_7_days":"Letzten 7 Tage","last_month":"Im vergangenen Monat","lunch_break":"Brechen","mar":"Marsch","may":"Mai","medicine_bill":"Medizingesetz","medicine_bill_already_use":"Dieses Arzneimittel wird bereits in Arzneimittelrechnungen verwendet. M\u00f6chten Sie es wirklich l\u00f6schen?","medicine_required":"Fachrichtung Medizin ist erforderlich.","mon":"MO","monday":"Montag","net_amount_not_empty":"Der Nettobetrag darf nicht leer sein.","net_amount_not_zero":"Der Nettobetrag darf nicht Null sein.","no_ipd_patient_found":"W\u00e4hlen Sie IPD-Patient aus","notification_read":"Benachrichtigung erfolgreich gelesen.","nov":"November","oct":"Oktober","paid":"Bezahlt","password_not_match":"Passwort und Passwort best\u00e4tigen stimmen nicht \u00fcberein.","patient_not_exists_or_status_is_not_active":"Der Patient existiert nicht oder der Status ist nicht aktiv.","patient_required":"Patientenfeld ist erforderlich.","paypal_client_id":"Paypal-Kunden-ID","paypal_mode":"Bitte wechseln Sie in den PayPal-Modus.","paypal_secret":"Bitte geben Sie das PayPal-Geheimnis ein.","paystack_key":"Bitte geben Sie den \u00f6ffentlichen Paystack-Schl\u00fcssel ein.","paystack_secret":"Bitte geben Sie den geheimen Paystack-Schl\u00fcssel ein.","paytm_id":"Bitte geben Sie die Paytm-H\u00e4ndler-ID ein.","paytm_key":"Bitte geben Sie den Paytm-H\u00e4ndlerschl\u00fcssel ein.","phone_number":"Telefonnummer","please_enter_valid_Instagram_url":"Bitte geben Sie eine g\u00fcltige Instagram-URL ein","please_enter_valid_facebook_url":"Bitte geben Sie eine g\u00fcltige Facebook-URL ein","please_enter_valid_linkedin_url":"Bitte geben Sie eine g\u00fcltige LinkedIn-URL ein","please_enter_valid_twitter_url":"Bitte geben Sie eine g\u00fcltige Twitter-URL ein","please_select_doctor":"Bitte w\u00e4hlen Sie Arzt aus","privacy_policy":"Datenschutzrichtlinie","purchase_medicine":"Kaufen Sie Medikamente","qr_code_not_found":"QR-Code nicht gefunden.","qty_cannot_be_zero":"Die Menge darf nicht Null sein.","qty_must_be_less_than_available_qty":"Die Menge muss kleiner sein als die verf\u00fcgbare Menge.","quantity_greater_than_0":"Die Menge sollte gr\u00f6\u00dfer als 0 sein.","quantity_not_empty":"Die Menge darf nicht Null oder leer sein.","razor_pay_secret":"Bitte geben Sie das Razorpay-Geheimnis ein.","razorpay_key":"Bitte geben Sie den Razorpay-Schl\u00fcssel ein.","sat":"SA","saturday":"Samstag","select_account":"Konto ausw\u00e4hlen","select_appointment_date":"Bitte w\u00e4hlen Sie den Termin aus.","select_bed_type":"W\u00e4hlen Sie den Betttyp aus","select_calendar":"Bitte w\u00e4hlen Sie einen Kalender aus.","select_category":"Kategorie w\u00e4hlen","select_charge":"W\u00e4hlen Sie \u201eAufladen\u201c.","select_charge_category":"W\u00e4hlen Sie die Geb\u00fchrenkategorie aus","select_charge_type":"W\u00e4hlen Sie Kategorietyp aus","select_code":"W\u00e4hlen Sie Code aus","select_doctor":"W\u00e4hlen Sie Arzt","select_doctors":"W\u00e4hlen Sie \u00c4rzte aus","select_dose_interval":"W\u00e4hlen Sie Dosisintervall","select_duration":"W\u00e4hlen Sie Dauer aus","select_employee":"W\u00e4hlen Sie Mitarbeiter aus","select_ipd_patient":"W\u00e4hlen Sie IPD-Patient aus","select_item":"Men\u00fcpunkt w\u00e4hlen","select_medicine":"W\u00e4hlen Sie Medizin","select_parameter_name":"W\u00e4hlen Sie Parametername","select_patient":"W\u00e4hlen Sie Patient aus","select_service":"W\u00e4hlen Sie \u201eDienst\u201c.","select_time_slot":"Bitte w\u00e4hlen Sie den Termintermin aus.","select_type_number":"W\u00e4hlen Sie Typnummer aus","select_user":"Nutzer w\u00e4hlen","send_mail":"Mail senden","sending":"Senden...","sep":"September","smart_patient_card":"Patienten-Smartcard","status":"Status","stripe_key":"Bitte geben Sie Stripe Secret ein.","stripe_secret":"Streifengeheimnis","sun":"SONNE","sunday":"Sonntag","tax_less_100":"Die Steuern sollten weniger als 100 % betragen.","tax_not_empty":"Der Steuerbetrag darf nicht Null oder leer sein.","template_required":"Das Feld \u201eVorlagenname\u201c ist erforderlich.","terms_condition_required":"Die Allgemeinen Gesch\u00e4ftsbedingungen sind erforderlich.","terms_conditions":"Terms & amp; Bedingungen","this_month":"Diesen Monat","this_week":"Diese Woche","thu":"DO","thursday":"Donnerstag","to":"Zu","today":"Heute","too_long":"Zu lang","too_short":"Zu kurz","tue":"DI","tuesday":"Dienstag","u_want_to_complete_this_payment":"Sie m\u00f6chten diese Zahlung abschlie\u00dfen!","unpaid":"Unbezahlt","update_quantity":"Die Aktualisierungsmenge sollte geringer sein als die vorherige Menge.","value_field_required":"Das Wertfeld ist erforderlich.","value_must_be_greter_then":"Der Wert muss gr\u00f6\u00dfer als 1 sein","warning":"Warnung !","wed":"HEIRATEN","wednesday":"Mittwoch","yesterday":"Gestern","your_payment_failed":"Ihre Zahlung ist fehlgeschlagen.","zoom":"Zoomen"},"en.js":{"about_us_description":"Description","about_us_mission":"Mission","about_us_title":"Title","active":"Active","all_notification_read":"All Notification read successfully.","all_required_fields":"Please fill all the required fields.","apply":"Apply","appointment":"Appointment","appointment_cancel":"Appointment cancelled successfully.","apr":"April","are_u_sure":"Are you sure?","are_you_sure_want_to_cancel":"Are you sure want to cancel","are_you_sure_want_to_change":"Are you sure want to change ","are_you_sure_want_to_delete_this":"Are you sure want to delete this ","are_you_sure_want_to_return_this_item":"Are you sure want to return this item","aug":"August","available_quantity":"Available Quantity","break_time_greater_than_zero":"Break From time must be greater than Zero","break_to_time_greater_than_from_time":"Break To time must be greater than Break From time.","break_to_time_greater_than_zero":"Break To time must be greater than Zero","cancel":"Cancel","canceled":"Canceled","captcha_key":"Google Captcha key","captcha_secret":"Google Captcha Secret","card_template":"Patient Smart Card Template","change_status":"Change status","changed_appointment":"Changed Appointment","charchter_160":"The message may not be greater than 160 characters.","choose_bed":"Choose Bed","choose_case":"Choose Case","currency":"Currency","custom":"Custom","date_required":"Date field is required","deactive":"Deactive","dec":"December","deduction_not_greater_than_salary":"Deductions cannot be greater than Basic salary + Allowance","deleted":"Deleted","department":"Department","disconnect_or_reconnect":"Please disconnect and reconnect your google calendar","discount_less_than_amount":"The discount should be less than the total amount.","doctor_schedule_not_available_on_this_date":"Doctor Schedule not available this date.","document_file_size":"The document must be a file of type: jpeg, jpg, png, pdf, doc, docx., mp3, mp4","document_must_be_file_type":"The document must be a file of type: jpeg, jpg, png, pdf, doc, docx.","enter_lot_no":"Enter lot number .","enter_purchase_price":"Enter purchase price.","enter_sale_price":"Enter sale price.","feb":"February","field_not_contain_white_space":"field is not contain only white space","field_required":"field is Required.","fri":"FRI","friday":"Friday","from":"From","google_meet":"Google Meet","has_been_changed":"has been Changed.","has_been_deleted":"has been deleted.","holiday":"Holiday","home_page_box_description":"Home Page Box Description","home_page_box_title":"Home Page Box Title","home_page_certified_box_description":"Home Page Certified Box Description","home_page_certified_box_title":"Home Page Certified Box Title","home_page_certified_doctor_description":"Home Page Certified Doctor Description","home_page_certified_doctor_text":"Home Page Certified Doctor Text","home_page_certified_doctor_title":"Home Page Certified Doctor Title","home_page_description":"Home Page Description","home_page_experience":"Home Page Experience","home_page_step_1_description":"Home Page Step 1 Description","home_page_step_1_title":"Home Page Step 1 Title","home_page_step_2_description":"Home Page Step 2 Description","home_page_step_2_title":"Home Page Step 2 Title","home_page_step_3_description":"Home Page Step 3 Description","home_page_step_3_title":"Home Page Step 3 Title","home_page_step_4_description":"Home Page Step 4 Description","home_page_step_4_title":"Home Page Step 4 Title","home_page_title":"Home Page Title","image_must_be":"The image must be a file of type: jpg, jpeg, png.","invalid_country_code":"Invalid country code","invalid_number":"Invalid number","ipd_timeline":"IPD Timeline","item_returned":"Item returned successfully.","jan":"January","jul":"July","jun":"June","last_30_days":"Last 30 days","last_7_days":"Last 7 days","last_month":"Last month","lunch_break":"Break","mar":"March","may":"May","medicine_bill":"Medicine Bill","medicine_bill_already_use":"This medicine is already used in medicine bills, are you sure want to delete it?","medicine_required":"Medicine field is required.","mon":"MON","monday":"Monday","net_amount_not_empty":"Net amount can not be empty.","net_amount_not_zero":"Net amount can not be zero.","no_ipd_patient_found":"No IPD Patient Found","notification_read":"Notification read successfully.","nov":"November","oct":"October","paid":"Paid","password_not_match":"Password and Confirm password not match.","patient_not_exists_or_status_is_not_active":"Patient not exists or status is not active.","patient_required":"Patient field is required.","paypal_client_id":"Paypal Client ID","paypal_mode":"Please enter paypal mode.","paypal_secret":"Please enter paypal secret.","paystack_key":"Please enter paystack public Key.","paystack_secret":"Please enter paystack secret Key.","paytm_id":"Please enter paytm merchant Id.","paytm_key":"Please enter paytm merchant Key.","phone_number":"Phone Number","please_enter_valid_Instagram_url":"Please enter a valid Instagram URL","please_enter_valid_facebook_url":"Please enter a valid facebook URL","please_enter_valid_linkedin_url":"Please enter a valid LinkedIn URL","please_enter_valid_twitter_url":"Please enter a valid Twitter URL","please_select_doctor":"Please select Doctor","privacy_policy":"Privacy Policy","purchase_medicine":"Purchase Medicine","qr_code_not_found":"QR code not found.","qty_cannot_be_zero":"Quantity cannot be zero.","qty_must_be_less_than_available_qty":"Quantity must be less than Available quantity.","quantity_greater_than_0":"Quantity should be greater than 0.","quantity_not_empty":"Quantity cannot be zero or empty.","razor_pay_secret":"Please enter razorpay Secret.","razorpay_key":"Please enter razorpay key.","sat":"SAT","saturday":"Saturday","select_account":"Select Account","select_appointment_date":"Please select appointment date.","select_bed_type":"Select Bed Type","select_blood_group":"Select Blood Group","select_calendar":"Please select a calendar.","select_category":"Select Category","select_charge":"Select Charge","select_charge_category":"Select Charge Category","select_charge_type":"Select Category Type","select_code":"Select Code","select_doctor":"Select Doctor","select_doctors":"Select Doctors","select_dose_interval":"Select Dose Interval","select_duration":"Select Duration","select_employee":"Select Employee","select_ipd_patient":"Select IPD Patient","select_item":"Select Item","select_medicine":"Select Medicine","select_parameter_name":"Select Parameter Name","select_patient":"Select Patient","select_service":"Select Service","select_time_slot":"Please select appointment time slot.","select_type_number":"Select Type Number","select_user":"Select User","send_mail":"Send Mail","sending":"Sending...","sep":"September","smart_patient_card":"Patient Smart Card","status":"Status","stripe_key":"Please enter Stripe Secret.","stripe_secret":"Stripe Secret","sun":"SUN","sunday":"Sunday","tax_less_100":"Taxes should be less than 100%.","tax_not_empty":"The tax amount can not be zero or empty.","template_required":"Template Name field is required.","terms_condition_required":"The Terms & Conditions is required.","terms_conditions":"Terms & Conditions","this_month":"This month","this_week":"This Week","thu":"THU","thursday":"Thursday","to":"To","today":"Today","too_long":"Too long","too_short":"Too short","tue":"TUE","tuesday":"Tuesday","u_want_to_complete_this_payment":"You want to complete this payment!","unpaid":"Unpaid","update_quantity":"Update quantity should be less than previous quantity.","value_field_required":"The value field is required.","value_must_be_greter_then":"Value must be greter then 1","warning":"Warning !","wed":"WED","wednesday":"Wednesday","yesterday":"Yesterday","your_payment_failed":"Your Payment is failed.","zoom":"Zoom"},"es.js":{"about_us_description":"Descripci\u00f3n","about_us_mission":"Misi\u00f3n","about_us_title":"T\u00edtulo","active":"Activa","all_notification_read":"Todas las notificaciones se leyeron correctamente.","all_required_fields":"Por favor complete todos los campos requeridos.","apply":"Aplicar","appointment":"Cita","appointment_cancel":"Cita cancelada exitosamente.","apr":"Abril","are_u_sure":"Estas segura","are_you_sure_want_to_cancel":"Seguro que quieres cancelar","are_you_sure_want_to_change":"Estas segura de querer cambiar ","are_you_sure_want_to_delete_this":"\u00bfEst\u00e1s segura de que quieres eliminar esto? ","are_you_sure_want_to_return_this_item":"\u00bfEst\u00e1s segura de que quieres devolver este art\u00edculo?","aug":"Agosto","available_quantity":"Cantidad disponible","break_time_greater_than_zero":"El tiempo de ruptura debe ser mayor que cero","break_to_time_greater_than_from_time":"El tiempo de interrupci\u00f3n hasta debe ser mayor que el tiempo de interrupci\u00f3n desde.","break_to_time_greater_than_zero":"El tiempo de descanso debe ser mayor que cero.","cancel":"Cancelar","canceled":"Cancelada","captcha_key":"Clave Captcha de Google","captcha_secret":"Secreto de Captcha de Google","card_template":"Plantilla de tarjeta inteligente para pacientes","change_status":"Cambiar Estado","changed_appointment":"Cita cambiada","charchter_160":"El mensaje no podr\u00e1 tener m\u00e1s de 160 caracteres.","choose_bed":"Elige Cama","choose_case":"Elija caso","currency":"Divisa","custom":"Costumbre","date_required":"El campo de fecha es obligatorio","deactive":"Desactivado","dec":"Diciembre","deduction_not_greater_than_salary":"Las deducciones no pueden ser mayores que Salario b\u00e1sico + Asignaci\u00f3n","deleted":"Eliminada","department":"Departamento","disconnect_or_reconnect":"Desconecta y vuelve a conectar tu calendario de Google.","discount_less_than_amount":"El descuento debe ser menor que el monto total.","doctor_schedule_not_available_on_this_date":"Horario m\u00e9dico no disponible esta fecha.","document_file_size":"El documento debe ser un archivo de tipo: jpeg, jpg, png, pdf, doc, docx., mp3, mp4","document_must_be_file_type":"El documento debe ser un archivo de tipo: jpeg, jpg, png, pdf, doc, docx.","enter_lot_no":"Introduzca el n\u00famero de lote.","enter_purchase_price":"Introduzca el precio de compra.","enter_sale_price":"Ingrese el precio de venta.","feb":"Febrero","field_not_contain_white_space":"El campo no contiene solo espacios en blanco.","field_required":"Se requiere campo.","fri":"VIE","friday":"Viernes","from":"De","google_meet":"Reuni\u00f3n de Google","has_been_changed":"Ha sido cambiada.","has_been_deleted":"ha sido eliminado.","holiday":"D\u00eda festivo","home_page_box_description":"Descripci\u00f3n del cuadro de la p\u00e1gina de inicio","home_page_box_title":"T\u00edtulo del cuadro de la p\u00e1gina de inicio","home_page_certified_box_description":"Descripci\u00f3n de la caja certificada de la p\u00e1gina de inicio","home_page_certified_box_title":"T\u00edtulo del cuadro certificado de la p\u00e1gina de inicio","home_page_certified_doctor_description":"P\u00e1gina de inicio Descripci\u00f3n del m\u00e9dico certificado","home_page_certified_doctor_text":"Texto de m\u00e9dico certificado de la p\u00e1gina de inicio","home_page_certified_doctor_title":"P\u00e1gina de inicio T\u00edtulo de m\u00e9dico certificado","home_page_description":"Descripci\u00f3n de la p\u00e1gina de inicio","home_page_experience":"Experiencia en la p\u00e1gina de inicio","home_page_step_1_description":"P\u00e1gina de inicio Paso 1 Descripci\u00f3n","home_page_step_1_title":"P\u00e1gina de inicio Paso 1 T\u00edtulo","home_page_step_2_description":"P\u00e1gina de inicio Paso 2 Descripci\u00f3n","home_page_step_2_title":"P\u00e1gina de inicio Paso 2 T\u00edtulo","home_page_step_3_description":"P\u00e1gina de inicio Paso 3 Descripci\u00f3n","home_page_step_3_title":"P\u00e1gina de inicio Paso 3 T\u00edtulo","home_page_step_4_description":"P\u00e1gina de inicio Paso 4 Descripci\u00f3n","home_page_step_4_title":"P\u00e1gina de inicio Paso 4 T\u00edtulo","home_page_title":"T\u00edtulo de la p\u00e1gina de inicio","image_must_be":"La imagen debe ser un archivo de tipo: jpg, jpeg, png.","invalid_country_code":"C\u00f3digo de pa\u00eds no v\u00e1lido","invalid_number":"N\u00famero invalido","ipd_timeline":"Cronolog\u00eda del DPI","item_returned":"Art\u00edculo devuelto correctamente.","jan":"Enero","jul":"Julio","jun":"Junio","last_30_days":"\u00faltimos 30 d\u00edas","last_7_days":"Los \u00faltimos 7 d\u00edas","last_month":"El mes pasado","lunch_break":"Romper","mar":"Marzo","may":"Puede","medicine_bill":"Proyecto de ley de medicamentos","medicine_bill_already_use":"Este medicamento ya se utiliza en las facturas de medicamentos, \u00bfseguro que deseas eliminarlo?","medicine_required":"Se requiere campo de medicina.","mon":"LUN","monday":"Lunes","net_amount_not_empty":"El importe neto no puede estar vac\u00edo.","net_amount_not_zero":"El importe neto no puede ser cero.","no_ipd_patient_found":"No se encontr\u00f3 ning\u00fan paciente con IPD","notification_read":"Notificaci\u00f3n le\u00edda exitosamente.","nov":"Noviembre","oct":"Octubre","paid":"Pagada","password_not_match":"Contrase\u00f1a y Confirmar contrase\u00f1a no coinciden.","patient_not_exists_or_status_is_not_active":"La paciente no existe o el estado no est\u00e1 activo.","patient_required":"El campo del paciente es obligatorio.","paypal_client_id":"ID de cliente de Paypal","paypal_mode":"Por favor ingresa al modo paypal.","paypal_secret":"Por favor ingrese el secreto de PayPal.","paystack_key":" Ingrese la clave p\u00fablica de Paystack.","paystack_secret":"Ingrese la clave secreta de Paystack.","paytm_id":"Ingrese el ID del comerciante de Paytm.","paytm_key":"Ingrese la clave del comerciante de Paytm.","phone_number":"N\u00famero de tel\u00e9fono","please_enter_valid_Instagram_url":"Por favor ingresa una URL de Instagram v\u00e1lida","please_enter_valid_facebook_url":"Por favor ingresa una URL de Facebook v\u00e1lida","please_enter_valid_linkedin_url":"Introduce una URL de LinkedIn v\u00e1lida","please_enter_valid_twitter_url":"Por favor ingresa una URL de Twitter v\u00e1lida","please_select_doctor":"Por favor seleccione doctora","privacy_policy":"pol\u00edtica de privacidad","purchase_medicine":"Comprar Medicina","qr_code_not_found":"C\u00f3digo QR no encontrado.","qty_cannot_be_zero":"La cantidad no puede ser cero.","qty_must_be_less_than_available_qty":"La cantidad debe ser menor que la cantidad disponible.","quantity_greater_than_0":"La cantidad debe ser mayor que 0.","quantity_not_empty":"La cantidad no puede ser cero ni estar vac\u00eda.","razor_pay_secret":"Introduzca el secreto de Razorpay.","razorpay_key":"Introduzca la clave de Razorpay.","sat":"SE SENT\u00d3","saturday":"S\u00e1bado","select_account":"Seleccionar cuenta","select_appointment_date":"Por favor seleccione la fecha de la cita.","select_bed_type":"Seleccione tipo de cama","select_calendar":"Por favor seleccione un calendario.","select_category":"El descuento debe ser menor que el monto total.","select_charge":"Seleccionar cargo","select_charge_category":"Seleccionar categor\u00eda de cargo","select_charge_type":"Seleccionar tipo de categor\u00eda","select_code":"Seleccionar c\u00f3digo","select_doctor":"Seleccionar doctora","select_doctors":"Seleccionar doctores","select_dose_interval":"Seleccione el intervalo de dosis","select_duration":"Seleccionar duraci\u00f3n","select_employee":"Seleccionar empleada","select_ipd_patient":"Seleccionar paciente IPD","select_item":"Seleccione un art\u00edculo","select_medicine":"Seleccionar Medicina","select_parameter_name":"Seleccione el nombre del par\u00e1metro","select_patient":"Seleccionar Paciente","select_service":"Seleccionar Servicio","select_time_slot":"Por favor seleccione el horario de la cita.","select_type_number":"Seleccione el n\u00famero de tipo","select_user":"Seleccionar usuario","send_mail":"Enviar correo","sending":"Enviando...","sep":"Septiembre","smart_patient_card":"Tarjeta inteligente del paciente","status":"Estado","stripe_key":"Introduzca Stripe Secret.","stripe_secret":"Stripe Secret","sun":"SOL","sunday":"Domingo","tax_less_100":"Los impuestos deben ser inferiores al 100%.","tax_not_empty":"El monto del impuesto no puede ser cero ni estar vac\u00edo.","template_required":"El campo Nombre de la plantilla es obligatorio.","terms_condition_required":"Los T\u00e9rminos y condiciones son obligatorios.","terms_conditions":"T\u00e9rminos y condiciones","this_month":"Este mes","this_week":"Esta semana","thu":"JUE","thursday":"Jueves","to":"A","today":"Hoy","too_long":"Demasiado larga","too_short":"Demasiado corta","tue":"MAR","tuesday":"Martes","u_want_to_complete_this_payment":"\u00a1Quieres completar este pago!","unpaid":"No pagado","update_quantity":"La cantidad de actualizaci\u00f3n debe ser menor que la cantidad anterior.","value_field_required":"El campo de valor es obligatorio.","value_must_be_greter_then":"El valor debe ser mayor que 1.","warning":"Advertencia !","wed":"CASARSE","wednesday":"Mi\u00e9rcoles","yesterday":"Ayer","your_payment_failed":"Su pago ha fallado.","zoom":"Zoom"},"fr.js":{"about_us_description":"Description","about_us_mission":"Mission","about_us_title":"Title","active":"Active","all_notification_read":"All Notification read successfully.","all_required_fields":"Please fill all the required fields.","apply":"Apply","appointment":"Appointment","appointment_cancel":"Appointment cancelled successfully.","apr":"April","are_u_sure":"Are you sure?","are_you_sure_want_to_cancel":"Are you sure want to cancel","are_you_sure_want_to_change":"Are you sure want to change ","are_you_sure_want_to_delete_this":"Are you sure want to delete this ","are_you_sure_want_to_return_this_item":"Are you sure want to return this item","aug":"August","available_quantity":"Available Quantity","break_time_greater_than_zero":"Break From time must be greater than Zero","break_to_time_greater_than_from_time":"Break To time must be greater than Break From time.","break_to_time_greater_than_zero":"Break To time must be greater than Zero","cancel":"Cancel","canceled":"Canceled","captcha_key":"Google Captcha key","captcha_secret":"Google Captcha Secret","card_template":"Patient Smart Card Template","change_status":"Change status","changed_appointment":"Changed Appointment","charchter_160":"The message may not be greater than 160 characters.","choose_bed":"Choose Bed","choose_case":"Choose Case","currency":"Currency","custom":"Custom","date_required":"Date field is required","deactive":"Deactive","dec":"December","deduction_not_greater_than_salary":"Deductions cannot be greater than Basic salary + Allowance","deleted":"Deleted","department":"Department","disconnect_or_reconnect":"Veuillez d\u00e9connecter et reconnecter votre agenda Google","discount_less_than_amount":"The discount should be less than the total amount.","doctor_schedule_not_available_on_this_date":"Doctor Schedule not available this date.","document_file_size":"The document must be a file of type: jpeg, jpg, png, pdf, doc, docx., mp3, mp4","document_must_be_file_type":"The document must be a file of type: jpeg, jpg, png, pdf, doc, docx.","enter_lot_no":"Enter lot number .","enter_purchase_price":"Enter purchase price.","enter_sale_price":"Enter sale price.","feb":"February","field_not_contain_white_space":"field is not contain only white space","field_required":"Champ requis.","fri":"FRI","friday":"Friday","from":"From","google_meet":"Google Rencontre","has_been_changed":"has been Changed.","has_been_deleted":"has been deleted.","holiday":"Holiday","home_page_box_description":"Home Page Box Description","home_page_box_title":"Home Page Box Title","home_page_certified_box_description":"Home Page Certified Box Description","home_page_certified_box_title":"Home Page Certified Box Title","home_page_certified_doctor_description":"Home Page Certified Doctor Description","home_page_certified_doctor_text":"Home Page Certified Doctor Text","home_page_certified_doctor_title":"Home Page Certified Doctor Title","home_page_description":"Home Page Description","home_page_experience":"Home Page Experience","home_page_step_1_description":"Home Page Step 1 Description","home_page_step_1_title":"Home Page Step 1 Title","home_page_step_2_description":"Home Page Step 2 Description","home_page_step_2_title":"Home Page Step 2 Title","home_page_step_3_description":"Home Page Step 3 Description","home_page_step_3_title":"Home Page Step 3 Title","home_page_step_4_description":"Home Page Step 4 Description","home_page_step_4_title":"Home Page Step 4 Title","home_page_title":"Home Page Title","image_must_be":"The image must be a file of type: jpg, jpeg, png.","invalid_country_code":"Invalid country code","invalid_number":"Invalid number","ipd_timeline":"IPD Timeline","item_returned":"Item returned successfully.","jan":"January","jul":"July","jun":"June","last_30_days":"Last 30 days","last_7_days":"Last 7 days","last_month":"Last month","lunch_break":"Break","mar":"March","may":"May","medicine_bill":"Medicine Bill","medicine_bill_already_use":"This medicine is already used in medicine bills, are you sure want to delete it?","medicine_required":"Medicine field is required.","mon":"MON","monday":"Monday","net_amount_not_empty":"Net amount can not be empty.","net_amount_not_zero":"Net amount can not be zero.","no_ipd_patient_found":"No IPD Patient Found","notification_read":"Notification read successfully.","nov":"November","oct":"October","paid":"Paid","password_not_match":"Password and Confirm password not match.","patient_not_exists_or_status_is_not_active":"Patient not exists or status is not active.","patient_required":"Patient field is required.","paypal_client_id":"Paypal Client ID","paypal_mode":"Please enter paypal mode.","paypal_secret":"Please enter paypal secret.","paystack_key":"Please enter paystack public Key.","paystack_secret":"Please enter paystack secret Key.","paytm_id":"Please enter paytm merchant Id.","paytm_key":"Please enter paytm merchant Key.","phone_number":"Phone Number","please_enter_valid_Instagram_url":"Please enter a valid Instagram URL","please_enter_valid_facebook_url":"Please enter a valid facebook URL","please_enter_valid_linkedin_url":"Please enter a valid LinkedIn URL","please_enter_valid_twitter_url":"Please enter a valid Twitter URL","please_select_doctor":"Please select Doctor","privacy_policy":"Privacy Policy","purchase_medicine":"Purchase Medicine","qr_code_not_found":"QR code not found.","qty_cannot_be_zero":"Quantity cannot be zero.","qty_must_be_less_than_available_qty":"Quantity must be less than Available quantity.","quantity_greater_than_0":"Quantity should be greater than 0.","quantity_not_empty":"Quantity cannot be zero or empty.","razor_pay_secret":"Please enter razorpay Secret.","razorpay_key":"Please enter razorpay key.","sat":"SAT","saturday":"Saturday","select_account":"Select Account","select_appointment_date":"Please select appointment date.","select_bed_type":"Select Bed Type","select_calendar":"Veuillez s\u00e9lectionner un calendrier.","select_category":"Select Category","select_charge":"Select Charge","select_charge_category":"Select Charge Category","select_charge_type":"Select Category Type","select_code":"Select Code","select_doctor":"Select Doctor","select_doctors":"Select Doctors","select_dose_interval":"Select Dose Interval","select_duration":"Select Duration","select_employee":"Select Employee","select_ipd_patient":"Select IPD Patient","select_item":"Select Item","select_medicine":"Select Medicine","select_parameter_name":"Select Parameter Name","select_patient":"Select Patient","select_service":"Select Service","select_time_slot":"Please select appointment time slot.","select_type_number":"Select Type Number","select_user":"Select User","send_mail":"Send Mail","sending":"Sending...","sep":"September","smart_patient_card":"Patient Smart Card","status":"Status","stripe_key":"Please enter Stripe Secret.","stripe_secret":"Stripe Secret","sun":"SUN","sunday":"Sunday","tax_less_100":"Taxes should be less than 100%.","tax_not_empty":"The tax amount can not be zero or empty.","template_required":"Template Name field is required.","terms_condition_required":"The Terms & Conditions is required.","terms_conditions":"Terms & Conditions","this_month":"This month","this_week":"This Week","thu":"THU","thursday":"Thursday","to":"To","today":"Today","too_long":"Too long","too_short":"Too short","tue":"TUE","tuesday":"Tuesday","u_want_to_complete_this_payment":"You want to complete this payment!","unpaid":"Unpaid","update_quantity":"Update quantity should be less than previous quantity.","value_field_required":"Le champ valeur est obligatoire.","value_must_be_greter_then":"La valeur doit \u00eatre sup\u00e9rieure \u00e0 1","warning":"Warning !","wed":"WED","wednesday":"Wednesday","yesterday":"Yesterday","your_payment_failed":"Your Payment is failed.","zoom":"Zoom"},"pt.js":{"about_us_description":"Descri\u00e7\u00e3o","about_us_mission":"Miss\u00e3o","about_us_title":"T\u00edtulo","active":"Ativa","all_notification_read":"Todas as notifica\u00e7\u00f5es foram lidas com sucesso.","all_required_fields":"Por favor preencha todos os campos obrigat\u00f3rios.","apply":"Aplicar","appointment":"Encontro","appointment_cancel":"Compromisso cancelado com sucesso.","apr":"abril","are_u_sure":"Tem certeza?","are_you_sure_want_to_cancel":"Tem certeza de que deseja cancelar","are_you_sure_want_to_change":"Tem certeza que deseja mudar ","are_you_sure_want_to_delete_this":"Tem certeza de que deseja excluir isto ","are_you_sure_want_to_return_this_item":"Tem certeza de que deseja devolver este item","aug":"Agosto","available_quantity":"Quantidade dispon\u00edvel","break_time_greater_than_zero":"O tempo de intervalo deve ser maior que zero","break_to_time_greater_than_from_time":"O tempo Break To deve ser maior que o tempo Break From.","break_to_time_greater_than_zero":"O tempo de interrup\u00e7\u00e3o deve ser maior que zero","cancel":"Cancelar","canceled":"Cancelada","captcha_key":"Chave do Google Captcha","captcha_secret":"Segredo do Google Captcha","card_template":"Modelo de cart\u00e3o inteligente do paciente","change_status":"Alterar status","changed_appointment":"Compromisso alterado","charchter_160":"A mensagem n\u00e3o pode ter mais de 160 caracteres.","choose_bed":"Escolha a cama","choose_case":"Escolha o caso","currency":"Moeda","custom":"Personalizada","date_required":"O campo data \u00e9 obrigat\u00f3rio","deactive":"Desativo","dec":"dezembro","deduction_not_greater_than_salary":"As dedu\u00e7\u00f5es n\u00e3o podem ser superiores ao sal\u00e1rio base + abono","deleted":"Exclu\u00edda","department":"Departamento","disconnect_or_reconnect":"Desconecte e reconecte seu Google Agenda","discount_less_than_amount":"O desconto deve ser menor que o valor total.","doctor_schedule_not_available_on_this_date":"Agenda M\u00e9dica n\u00e3o dispon\u00edvel nesta data.","document_file_size":"O documento deve ser um arquivo do tipo: jpeg, jpg, png, pdf, doc, docx., mp3, mp4","document_must_be_file_type":"O documento deve ser um arquivo do tipo: jpeg, jpg, png, pdf, doc, docx.","enter_lot_no":"Insira o n\u00famero do lote.","enter_purchase_price":"Insira o pre\u00e7o de compra.","enter_sale_price":"Insira o pre\u00e7o de venda.","feb":"Fevereiro","field_not_contain_white_space":"field is not contain only white space","field_required":"campo \u00e9 obrigat\u00f3rio.","fri":"SEX","friday":"Sexta-feira","from":"De","google_meet":"Google Meet","has_been_changed":"foi mudado.","has_been_deleted":"foi deletado.","holiday":"Feriado","home_page_box_description":"Descri\u00e7\u00e3o da caixa da p\u00e1gina inicial","home_page_box_title":"T\u00edtulo da caixa da p\u00e1gina inicial","home_page_certified_box_description":"Descri\u00e7\u00e3o da caixa certificada da p\u00e1gina inicial","home_page_certified_box_title":"T\u00edtulo da caixa certificada da p\u00e1gina inicial","home_page_certified_doctor_description":"Descri\u00e7\u00e3o do m\u00e9dico certificado da p\u00e1gina inicial","home_page_certified_doctor_text":"Texto do m\u00e9dico certificado da p\u00e1gina inicial","home_page_certified_doctor_title":"T\u00edtulo de m\u00e9dico certificado da p\u00e1gina inicial","home_page_description":"Descri\u00e7\u00e3o da p\u00e1gina inicial","home_page_experience":"Experi\u00eancia na p\u00e1gina inicial","home_page_step_1_description":"P\u00e1gina inicial, etapa 1 Descri\u00e7\u00e3o","home_page_step_1_title":"T\u00edtulo da etapa 1 da p\u00e1gina inicial","home_page_step_2_description":"P\u00e1gina inicial, etapa 2 Descri\u00e7\u00e3o","home_page_step_2_title":"T\u00edtulo da etapa 2 da p\u00e1gina inicial","home_page_step_3_description":"P\u00e1gina inicial, etapa 3 Descri\u00e7\u00e3o","home_page_step_3_title":"T\u00edtulo da etapa 3 da p\u00e1gina inicial","home_page_step_4_description":"P\u00e1gina inicial, etapa 4 Descri\u00e7\u00e3o","home_page_step_4_title":"T\u00edtulo da etapa 4 da p\u00e1gina inicial","home_page_title":"T\u00edtulo da p\u00e1gina inicial","image_must_be":"A imagem deve ser um arquivo do tipo: jpg, jpeg, png.","invalid_country_code":"C\u00f3digo de pa\u00eds inv\u00e1lido","invalid_number":"N\u00famero inv\u00e1lido","ipd_timeline":"Linha do tempo do IPD","item_returned":"Item retornado com sucesso.","jan":"Janeiro","jul":"Julho","jun":"Junho","last_30_days":"\u00daltimos 30 dias","last_7_days":"\u00daltimos 7 dias","last_month":"M\u00eas passado","lunch_break":"Quebrar","mar":"Marchar","may":"Poderia","medicine_bill":"Projeto de Lei de Medicamentos","medicine_bill_already_use":"Este medicamento j\u00e1 \u00e9 utilizado nas faturas de medicamentos. Tem certeza de que deseja exclu\u00ed-lo?","medicine_required":"A \u00e1rea de medicina \u00e9 obrigat\u00f3ria.","mon":"SEG","monday":"Segunda-feira","net_amount_not_empty":"O valor l\u00edquido n\u00e3o pode estar vazio.","net_amount_not_zero":"O valor l\u00edquido n\u00e3o pode ser zero.","no_ipd_patient_found":"Nenhum paciente com DPI encontrado","notification_read":"Notifica\u00e7\u00e3o lida com sucesso.","nov":"novembro","oct":"Outubro","paid":"Paga","password_not_match":"Senha e Confirmar senha n\u00e3o coincidem.","patient_not_exists_or_status_is_not_active":"O paciente n\u00e3o existe ou o status n\u00e3o est\u00e1 ativo.","patient_required":"O campo paciente \u00e9 obrigat\u00f3rio.","paypal_client_id":"ID do cliente Paypal","paypal_mode":"Por favor, entre no modo paypal.","paypal_secret":"Por favor, insira o segredo do PayPal.","paystack_key":"Insira a chave p\u00fablica da pilha de pagamentos.","paystack_secret":"Insira a chave secreta da pilha de pagamentos.","paytm_id":"Insira o ID do comerciante paytm.","paytm_key":"Insira a chave do comerciante paytm.","phone_number":"N\u00famero de telefone","please_enter_valid_Instagram_url":"Insira um URL v\u00e1lido do Instagram","please_enter_valid_facebook_url":"Por favor insira um URL v\u00e1lido do Facebook","please_enter_valid_linkedin_url":"Insira um URL v\u00e1lido do LinkedIn","please_enter_valid_twitter_url":"Insira um URL v\u00e1lido do Twitter","please_select_doctor":"Por favor selecione M\u00e9dico","privacy_policy":"pol\u00edtica de Privacidade","purchase_medicine":"Comprar rem\u00e9dio","qr_code_not_found":"C\u00f3digo QR n\u00e3o encontrado.","qty_cannot_be_zero":"A quantidade n\u00e3o pode ser zero.","qty_must_be_less_than_available_qty":"A quantidade deve ser menor que a quantidade dispon\u00edvel.","quantity_greater_than_0":"A quantidade deve ser maior que 0.","quantity_not_empty":"A quantidade n\u00e3o pode ser zero ou vazia.","razor_pay_secret":"Por favor, insira o segredo do razorpay.","razorpay_key":"Por favor, insira a chave razorpay.","sat":"SENTADA","saturday":"S\u00e1bado","select_account":"Selecione a conta","select_appointment_date":"Selecione a data do agendamento.","select_bed_type":"Selecione o tipo de cama","select_calendar":"Selecione um calend\u00e1rio.","select_category":"Selecione a Categoria","select_charge":"Selecione Cobrar","select_charge_category":"Selecione a categoria de cobran\u00e7a","select_charge_type":"Selecione o tipo de categoria","select_code":"Selecione o c\u00f3digo","select_doctor":"Selecione M\u00e9dico","select_doctors":"Selecione M\u00e9dicos","select_dose_interval":"Selecione o intervalo de dose","select_duration":"Selecione Dura\u00e7\u00e3o","select_employee":"Selecione Funcion\u00e1rio","select_ipd_patient":"Selecione Paciente IPD","select_item":"Selecionar item","select_medicine":"Selecione o medicamento","select_parameter_name":"Selecione o nome do par\u00e2metro","select_patient":"Selecione Paciente","select_service":"Selecione o servi\u00e7o","select_time_slot":"Selecione o hor\u00e1rio do agendamento.","select_type_number":"Selecione o tipo de n\u00famero","select_user":"Selecione o usu\u00e1rio","send_mail":"Enviar correio","sending":"Enviando...","sep":"Setembro","smart_patient_card":"Cart\u00e3o inteligente do paciente","status":"Status","stripe_key":"Por favor insira Stripe Secret.","stripe_secret":"Segredo de listra","sun":"SOL","sunday":"Domingo","tax_less_100":"Os impostos devem ser inferiores a 100%.","tax_not_empty":"O valor do imposto n\u00e3o pode ser zero ou vazio.","template_required":"O campo Nome do modelo \u00e9 obrigat\u00f3rio.","terms_condition_required":"Os Termos e Condi\u00e7\u00f5es s\u00e3o obrigat\u00f3rios.","terms_conditions":"termos e Condi\u00e7\u00f5es","this_month":"Este m\u00eas","this_week":"Essa semana","thu":"QUI","thursday":"Quinta-feira","to":"Para","today":"Hoje","too_long":"Demasiado longo","too_short":"Muito curto","tue":"TER","tuesday":"Ter\u00e7a-feira","u_want_to_complete_this_payment":"Voc\u00ea deseja concluir este pagamento!","unpaid":"N\u00e3o pago","update_quantity":"A quantidade atualizada deve ser menor que a quantidade anterior.","value_field_required":"O campo valor \u00e9 obrigat\u00f3rio.","value_must_be_greter_then":"O valor deve ser maior que 1","warning":"Aviso !","wed":"QUA","wednesday":"Quarta-feira","yesterday":"Ontem","your_payment_failed":"Seu pagamento falhou.","zoom":"Amplia\u00e7\u00e3o"},"ru.js":{"about_us_description":"\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435","about_us_mission":"\u041c\u0438\u0441\u0441\u0438\u044f","about_us_title":"\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a","active":"\u0410\u043a\u0442\u0438\u0432\u043d\u044b\u0439","all_notification_read":"\u0412\u0441\u0435 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u044b \u0443\u0441\u043f\u0435\u0448\u043d\u043e.","all_required_fields":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0437\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u0435 \u0432\u0441\u0435 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043f\u043e\u043b\u044f.","apply":"\u041f\u0440\u0438\u043c\u0435\u043d\u044f\u0442\u044c","appointment":"\u0412\u0441\u0442\u0440\u0435\u0447\u0430","appointment_cancel":"\u0412\u0441\u0442\u0440\u0435\u0447\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430.","apr":"\u0430\u043f\u0440\u0435\u043b\u044c","are_u_sure":"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b?","are_you_sure_want_to_cancel":"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043e\u0442\u043c\u0435\u043d\u0438\u0442\u044c?","are_you_sure_want_to_change":"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c ","are_you_sure_want_to_delete_this":"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u0442\u043e? ","are_you_sure_want_to_return_this_item":"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0432\u0435\u0440\u043d\u0443\u0442\u044c \u044d\u0442\u043e\u0442 \u0442\u043e\u0432\u0430\u0440?","aug":"\u0410\u0432\u0433\u0443\u0441\u0442","available_quantity":"\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e","break_time_greater_than_zero":"\u0412\u0440\u0435\u043c\u044f \u043f\u0435\u0440\u0435\u0440\u044b\u0432\u0430 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0443\u043b\u044f.","break_to_time_greater_than_from_time":"\u0412\u0440\u0435\u043c\u044f \u043f\u0435\u0440\u0435\u0440\u044b\u0432\u0430 \u0434\u043e \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u043f\u0435\u0440\u0435\u0440\u044b\u0432\u0430.","break_to_time_greater_than_zero":"\u0412\u0440\u0435\u043c\u044f \u043f\u0435\u0440\u0435\u0440\u044b\u0432\u0430 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0443\u043b\u044f.","cancel":"\u041e\u0442\u043c\u0435\u043d\u0430","canceled":"\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e","captcha_key":"\u041a\u043b\u044e\u0447 Google Captcha","captcha_secret":"\u0421\u0435\u043a\u0440\u0435\u0442 Google-\u043a\u0430\u043f\u0447\u0438","card_template":"\u0428\u0430\u0431\u043b\u043e\u043d \u0441\u043c\u0430\u0440\u0442-\u043a\u0430\u0440\u0442\u044b \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430","change_status":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441","changed_appointment":"\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u043e \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435","charchter_160":"\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u0442\u044c 160 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432.","choose_bed":"\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u043a\u0440\u043e\u0432\u0430\u0442\u044c","choose_case":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u043b\u0443\u0447\u0430\u0439","currency":"\u0412\u0430\u043b\u044e\u0442\u0430","custom":"\u041e\u0431\u044b\u0447\u0430\u0439","date_required":"\u041f\u043e\u043b\u0435 \u0434\u0430\u0442\u044b \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e","deactive":"\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d","dec":"\u0414\u0435\u043a\u0430\u0431\u0440\u044c","deduction_not_greater_than_salary":"\u0412\u044b\u0447\u0435\u0442\u044b \u043d\u0435 \u043c\u043e\u0433\u0443\u0442 \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u0442\u044c \u0431\u0430\u0437\u043e\u0432\u0443\u044e \u0437\u0430\u0440\u043f\u043b\u0430\u0442\u0443 + \u043d\u0430\u0434\u0431\u0430\u0432\u043a\u0443.","deleted":"\u0423\u0434\u0430\u043b\u0435\u043d\u043e","department":"\u041e\u0442\u0434\u0435\u043b\u0435\u043d\u0438\u0435","disconnect_or_reconnect":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u0435 \u0438 \u0441\u043d\u043e\u0432\u0430 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u0435 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c Google.","discount_less_than_amount":"\u0421\u043a\u0438\u0434\u043a\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u043e\u0431\u0449\u0435\u0439 \u0441\u0443\u043c\u043c\u044b.","doctor_schedule_not_available_on_this_date":"\u0420\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432\u0440\u0430\u0447\u0435\u0439 \u043d\u0430 \u044d\u0442\u0443 \u0434\u0430\u0442\u0443 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e.","document_file_size":"\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u044f\u0442\u044c \u0441\u043e\u0431\u043e\u0439 \u0444\u0430\u0439\u043b \u0442\u0438\u043f\u0430: jpeg, jpg, png, pdf, doc, docx., mp3, mp4.","document_must_be_file_type":"\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u044f\u0442\u044c \u0441\u043e\u0431\u043e\u0439 \u0444\u0430\u0439\u043b \u0442\u0438\u043f\u0430: jpeg, jpg, png, pdf, doc, docx.","enter_lot_no":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u043e\u043c\u0435\u0440 \u043b\u043e\u0442\u0430.","enter_purchase_price":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0446\u0435\u043d\u0443 \u043f\u043e\u043a\u0443\u043f\u043a\u0438.","enter_sale_price":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0446\u0435\u043d\u0443 \u043f\u0440\u043e\u0434\u0430\u0436\u0438.","feb":"\u0444\u0435\u0432\u0440\u0430\u043b\u044c","field_not_contain_white_space":"\u043f\u043e\u043b\u0435 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432","field_required":"\u041f\u043e\u043b\u0435, \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0434\u043b\u044f \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f.","fri":"\u041f\u0422","friday":"\u041f\u044f\u0442\u043d\u0438\u0446\u0430","from":"\u041e\u0442","google_meet":"Google \u0412\u0441\u0442\u0440\u0435\u0447\u0430","has_been_changed":"\u0431\u044b\u043b \u0438\u0437\u043c\u0435\u043d\u0435\u043d.","has_been_deleted":"\u0431\u044b\u043b \u0443\u0434\u0430\u043b\u0435\u043d.","holiday":"\u041f\u0440\u0430\u0437\u0434\u043d\u0438\u0447\u043d\u044b\u0439 \u0434\u0435\u043d\u044c","home_page_box_description":"\u0413\u043b\u0430\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430 \u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043f\u043e\u043b\u044f","home_page_box_title":"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u043b\u044f \u0434\u043e\u043c\u0430\u0448\u043d\u0435\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b","home_page_certified_box_description":"\u0413\u043b\u0430\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430 \u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0439 \u043a\u043e\u0440\u043e\u0431\u043a\u0438","home_page_certified_box_title":"\u0421\u0435\u0440\u0442\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u043e\u0440\u043e\u0431\u043a\u0438 \u043d\u0430 \u0433\u043b\u0430\u0432\u043d\u043e\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435","home_page_certified_doctor_description":"\u0413\u043b\u0430\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430 \u0421\u0435\u0440\u0442\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0432\u0440\u0430\u0447 \u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435","home_page_certified_doctor_text":"\u0414\u043e\u043c\u0430\u0448\u043d\u044f\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430 \u0421\u0435\u0440\u0442\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0434\u043e\u043a\u0442\u043e\u0440 \u0422\u0435\u043a\u0441\u0442","home_page_certified_doctor_title":"\u0414\u043e\u043c\u0430\u0448\u043d\u044f\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430 \u0421\u0435\u0440\u0442\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0434\u043e\u043a\u0442\u043e\u0440","home_page_description":"\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0434\u043e\u043c\u0430\u0448\u043d\u0435\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b","home_page_experience":"\u0414\u043e\u043c\u0430\u0448\u043d\u044f\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430 \u041e\u043f\u044b\u0442","home_page_step_1_description":"\u0414\u043e\u043c\u0430\u0448\u043d\u044f\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430 \u0428\u0430\u0433 1 \u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435","home_page_step_1_title":"\u0414\u043e\u043c\u0430\u0448\u043d\u044f\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430 \u0428\u0430\u0433 1 \u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435","home_page_step_2_description":"\u0414\u043e\u043c\u0430\u0448\u043d\u044f\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430 \u0428\u0430\u0433 2 \u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435","home_page_step_2_title":"\u0414\u043e\u043c\u0430\u0448\u043d\u044f\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430 \u0428\u0430\u0433 2 \u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435","home_page_step_3_description":"\u0414\u043e\u043c\u0430\u0448\u043d\u044f\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430 \u0428\u0430\u0433 3 \u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435","home_page_step_3_title":"\u0414\u043e\u043c\u0430\u0448\u043d\u044f\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430 \u0428\u0430\u0433 3 \u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435","home_page_step_4_description":"\u0414\u043e\u043c\u0430\u0448\u043d\u044f\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430 \u0428\u0430\u0433 4 \u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435","home_page_step_4_title":"\u0414\u043e\u043c\u0430\u0448\u043d\u044f\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430 \u0428\u0430\u0433 4 \u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435","home_page_title":"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043e\u043c\u0430\u0448\u043d\u0435\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b","image_must_be":"\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0444\u0430\u0439\u043b\u043e\u043c \u0442\u0438\u043f\u0430: jpg, jpeg, png.","invalid_country_code":"\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043a\u043e\u0434 \u0441\u0442\u0440\u0430\u043d\u044b","invalid_number":"\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440","ipd_timeline":"\u0425\u0440\u043e\u043d\u043e\u043b\u043e\u0433\u0438\u044f \u0418\u041f\u0414","item_returned":"\u0422\u043e\u0432\u0430\u0440 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0435\u043d.","jan":"\u044f\u043d\u0432\u0430\u0440\u044c","jul":"\u0418\u044e\u043b\u044c","jun":"\u0418\u044e\u043d\u044c","last_30_days":"\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 30 \u0434\u043d\u0435\u0439","last_7_days":"\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 7\u00a0\u0434\u043d\u0435\u0439","last_month":"\u041f\u0440\u043e\u0448\u043b\u044b\u0439 \u043c\u0435\u0441\u044f\u0446","lunch_break":"\u041f\u0435\u0440\u0435\u0440\u044b\u0432","mar":"\u041c\u0430\u0440\u0448\u0438\u0440\u043e\u0432\u0430\u0442\u044c","may":"\u041c\u043e\u0436\u0435\u0442","medicine_bill":"\u0421\u0447\u0435\u0442 \u0437\u0430 \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u0430","medicine_bill_already_use":"\u042d\u0442\u043e \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u043e \u0443\u0436\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 \u0441\u0447\u0435\u0442\u0430\u0445 \u0437\u0430 \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u0430. \u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0435\u0433\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c?","medicine_required":"\u041c\u0435\u0434\u0438\u0446\u0438\u043d\u0441\u043a\u043e\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e.","mon":"\u041f\u041d","monday":"\u041f\u043e\u043d\u0435\u0434\u0435\u043b\u044c\u043d\u0438\u043a","net_amount_not_empty":"\u0427\u0438\u0441\u0442\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c.","net_amount_not_zero":"\u0427\u0438\u0441\u0442\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043d\u0443\u043b\u0435\u0432\u043e\u0439.","no_ipd_patient_found":"\u041f\u0430\u0446\u0438\u0435\u043d\u0442 \u0441 \u0418\u041f\u0417 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d","notification_read":"\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435 \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e.","nov":"\u043d\u043e\u044f\u0431\u0440\u044c","oct":"\u041e\u043a\u0442\u044f\u0431\u0440\u044c","paid":"\u041e\u043f\u043b\u0430\u0447\u0435\u043d\u043d\u044b\u0439","password_not_match":"\u041f\u0430\u0440\u043e\u043b\u044c \u0438 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u043e\u043b\u044f \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442.","patient_not_exists_or_status_is_not_active":"\u041f\u0430\u0446\u0438\u0435\u043d\u0442 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0438\u043b\u0438 \u0441\u0442\u0430\u0442\u0443\u0441 \u043d\u0435 \u0430\u043a\u0442\u0438\u0432\u0435\u043d.","patient_required":"\u041f\u043e\u043b\u0435 \u00ab\u041f\u0430\u0446\u0438\u0435\u043d\u0442\u00bb \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e.","paypal_client_id":"\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043a\u043b\u0438\u0435\u043d\u0442\u0430 PayPal","paypal_mode":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u043e\u0439\u0434\u0438\u0442\u0435 \u0432 \u0440\u0435\u0436\u0438\u043c PayPal.","paypal_secret":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u0435\u043a\u0440\u0435\u0442 PayPal.","paystack_key":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u044b\u0439 \u043a\u043b\u044e\u0447 paystack.","paystack_secret":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u0435\u043a\u0440\u0435\u0442\u043d\u044b\u0439 \u043a\u043b\u044e\u0447 Paystack.","paytm_id":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u0440\u043e\u0434\u0430\u0432\u0446\u0430 paytm.","paytm_key":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u043a\u043b\u044e\u0447 \u043f\u0440\u043e\u0434\u0430\u0432\u0446\u0430 paytm.","phone_number":"\u041d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430","please_enter_valid_Instagram_url":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 URL-\u0430\u0434\u0440\u0435\u0441 Instagram","please_enter_valid_facebook_url":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 URL-\u0430\u0434\u0440\u0435\u0441 Facebook","please_enter_valid_linkedin_url":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 URL-\u0430\u0434\u0440\u0435\u0441 LinkedIn.","please_enter_valid_twitter_url":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 URL-\u0430\u0434\u0440\u0435\u0441 Twitter","please_select_doctor":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0414\u043e\u043a\u0442\u043e\u0440","privacy_policy":"\u043f\u043e\u043b\u0438\u0442\u0438\u043a\u0430 \u043a\u043e\u043d\u0444\u0438\u0434\u0435\u043d\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u0438","purchase_medicine":"\u041a\u0443\u043f\u0438\u0442\u044c \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u043e","qr_code_not_found":"QR-\u043a\u043e\u0434 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.","qty_cannot_be_zero":"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043d\u0443\u043b\u0435\u0432\u044b\u043c.","qty_must_be_less_than_available_qty":"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e\u0433\u043e \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0430.","quantity_greater_than_0":"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 0.","quantity_not_empty":"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043d\u0443\u043b\u0435\u0432\u044b\u043c \u0438\u043b\u0438 \u043f\u0443\u0441\u0442\u044b\u043c.","razor_pay_secret":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u0435\u043a\u0440\u0435\u0442 razorpay.","razorpay_key":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u043a\u043b\u044e\u0447 razorpay.","sat":"\u0421\u0418\u0414\u0415\u041b","saturday":"\u0421\u0443\u0431\u0431\u043e\u0442\u0430","select_account":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0447\u0435\u0442\u043d\u0443\u044e \u0437\u0430\u043f\u0438\u0441\u044c","select_appointment_date":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0430\u0442\u0443 \u0432\u0441\u0442\u0440\u0435\u0447\u0438.","select_bed_type":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u043a\u0440\u043e\u0432\u0430\u0442\u0438","select_calendar":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c.","select_category":"\u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e","select_charge":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u0430\u0440\u044f\u0434","select_charge_category":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e \u0437\u0430\u0440\u044f\u0434\u0430","select_charge_type":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438","select_code":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u043e\u0434","select_doctor":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0432\u0440\u0430\u0447\u0430","select_doctors":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0432\u0440\u0430\u0447\u0435\u0439","select_dose_interval":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u0434\u043e\u0437\u044b","select_duration":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c","select_employee":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a\u0430","select_ipd_patient":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430 \u0441 \u0418\u041f\u0417","select_item":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0440\u0435\u0434\u043c\u0435\u0442","select_medicine":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u043e","select_parameter_name":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0438\u043c\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430","select_patient":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430","select_service":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0443\u0441\u043b\u0443\u0433\u0443","select_time_slot":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u0432\u0441\u0442\u0440\u0435\u0447\u0438.","select_type_number":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043d\u043e\u043c\u0435\u0440 \u0442\u0438\u043f\u0430","select_user":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f","send_mail":"\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043f\u0438\u0441\u044c\u043c\u043e","sending":"\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430...","sep":"\u0421\u0435\u043d\u0442\u044f\u0431\u0440\u044c","smart_patient_card":"\u0421\u043c\u0430\u0440\u0442-\u043a\u0430\u0440\u0442\u0430 \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430","status":"\u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0434\u0435\u043b","stripe_key":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u0432\u0435\u0434\u0438\u0442\u0435 Stripe Secret.","stripe_secret":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u0432\u0435\u0434\u0438\u0442\u0435 Stripe Secret.","sun":"\u0421\u041e\u041b\u041d\u0426\u0415","sunday":"\u0412\u043e\u0441\u043a\u0440\u0435\u0441\u0435\u043d\u044c\u0435","tax_less_100":"\u041d\u0430\u043b\u043e\u0433\u0438 \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 100%.","tax_not_empty":"\u0421\u0443\u043c\u043c\u0430 \u043d\u0430\u043b\u043e\u0433\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0438\u043b\u0438 \u043f\u0443\u0441\u0442\u043e\u0439.","template_required":"\u041f\u043e\u043b\u0435 \u0418\u043c\u044f \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.","terms_condition_required":"\u0423\u0441\u043b\u043e\u0432\u0438\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u044f\u0432\u043b\u044f\u044e\u0442\u0441\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438.","terms_conditions":"\u0423\u0441\u043b\u043e\u0432\u0438\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f","this_month":"\u042d\u0442\u043e\u0442 \u043c\u0435\u0441\u044f\u0446","this_week":"\u041d\u0430 \u044d\u0442\u043e\u0439 \u043d\u0435\u0434\u0435\u043b\u0435","thu":"\u0427\u0422","thursday":"\u0427\u0435\u0442\u0432\u0435\u0440\u0433","to":"\u041a","today":"\u0421\u0435\u0433\u043e\u0434\u043d\u044f","too_long":"\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u0434\u043e\u043b\u0433\u043e","too_short":"\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u043a\u043e\u0440\u043e\u0442\u043a\u0438\u0439","tue":"\u0412\u0422","tuesday":"\u0412\u0442\u043e\u0440\u043d\u0438\u043a","u_want_to_complete_this_payment":"\u0412\u044b \u0445\u043e\u0442\u0438\u0442\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u0442\u044c \u044d\u0442\u043e\u0442 \u043f\u043b\u0430\u0442\u0435\u0436!","unpaid":"\u041d\u0435\u043e\u043f\u043b\u0430\u0447\u0438\u0432\u0430\u0435\u043c\u044b\u0439","update_quantity":"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0439 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u0433\u043e.","value_field_required":"\u041f\u043e\u043b\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.","value_must_be_greter_then":"\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 1","warning":"\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 !","wed":"\u041e\u0411\u0412\u0415\u041d\u0427\u0410\u041b\u0418\u0421\u042c","wednesday":"\u0421\u0440\u0435\u0434\u0430","yesterday":"\u0412\u0447\u0435\u0440\u0430","your_payment_failed":"\u0412\u0430\u0448 \u043f\u043b\u0430\u0442\u0435\u0436 \u043d\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d.","zoom":"\u0423\u0432\u0435\u043b\u0438\u0447\u0438\u0442\u044c"},"tr.js":{"about_us_description":"Tan\u0131m","about_us_mission":"Misyon","about_us_title":"Ba\u015fl\u0131k","active":"Aktif","all_notification_read":"T\u00fcm Bildirimler ba\u015far\u0131yla okundu.","all_required_fields":"L\u00fctfen gerekli t\u00fcm alanlar\u0131 doldurun.","apply":"Uygula","appointment":"Randevu","appointment_cancel":"Randevu ba\u015far\u0131yla iptal edildi.","apr":"Nisan","are_u_sure":"Emin misin?","are_you_sure_want_to_cancel":"\u0130ptal etmek istedi\u011fine emin misin","are_you_sure_want_to_change":"De\u011fi\u015ftirmek istedi\u011finden emin misin","are_you_sure_want_to_delete_this":"Bunu silmek istedi\u011finden emin misin? ","are_you_sure_want_to_return_this_item":"Bu \u00fcr\u00fcn\u00fc iade etmek istedi\u011finizden emin misiniz?","aug":"A\u011fustos","available_quantity":"Mevcut Miktar\u0131","break_time_greater_than_zero":"Break From zaman\u0131 S\u0131f\u0131rdan b\u00fcy\u00fck olmal\u0131d\u0131r","break_to_time_greater_than_from_time":"Mola zaman\u0131, Break From zaman\u0131ndan b\u00fcy\u00fck olmal\u0131d\u0131r.","break_to_time_greater_than_zero":"Break From zaman\u0131 S\u0131f\u0131rdan b\u00fcy\u00fck olmal\u0131d\u0131r","cancel":"\u0130ptal etmek","canceled":"\u0130ptal edildi","captcha_key":"Google Captcha anahtar\u0131","captcha_secret":"Google Captcha S\u0131rr\u0131","card_template":"Hasta Ak\u0131ll\u0131 Kart \u015eablonu","change_status":"Durum de\u011fi\u015ftirmek","changed_appointment":"Randevu De\u011fi\u015ftirildi","charchter_160":"Mesaj 160 karakterden uzun olamaz.","choose_bed":"Yatak Se\u00e7in","choose_case":"Vaka Se\u00e7","currency":"Para birimi","custom":"Gelenek","date_required":"Tarih alan\u0131 zorunludur","deactive":"Devre d\u0131\u015f\u0131","dec":"Aral\u0131k","deduction_not_greater_than_salary":"Kesintiler Temel maa\u015f + Har\u00e7l\u0131k tutar\u0131ndan fazla olamaz","deleted":"silindi","department":"Departman","disconnect_or_reconnect":"L\u00fctfen Google takviminizin ba\u011flant\u0131s\u0131n\u0131 kesin ve yeniden ba\u011flay\u0131n","discount_less_than_amount":"\u0130ndirim toplam tutardan az olmal\u0131d\u0131r.","doctor_schedule_not_available_on_this_date":"Doktor Program\u0131 bu tarihte mevcut de\u011fil.","document_file_size":"Belge \u015fu t\u00fcrde bir dosya olmal\u0131d\u0131r: jpeg, jpg, png, pdf, doc, docx., mp3, mp4","document_must_be_file_type":"Belge \u015fu t\u00fcrde bir dosya olmal\u0131d\u0131r: jpeg, jpg, png, pdf, doc, docx.","enter_lot_no":"Parti numaras\u0131n\u0131 girin.","enter_purchase_price":"Sat\u0131n alma fiyat\u0131n\u0131 girin.","enter_sale_price":"Sat\u0131\u015f fiyat\u0131n\u0131 girin.","feb":"\u015eubat","field_not_contain_white_space":"alan yaln\u0131zca bo\u015fluk i\u00e7ermiyor","field_required":"alan gereklidir.","fri":"Cuma","friday":"Cuma","from":"\u0130tibaren","google_meet":"Google Meet","has_been_changed":"de\u011fi\u015ftirildi.","has_been_deleted":"silindi.","holiday":"Tatil","home_page_box_description":"Ana Sayfa Kutu A\u00e7\u0131klamas\u0131","home_page_box_title":"Ana Sayfa Kutu Ba\u015fl\u0131\u011f\u0131","home_page_certified_box_description":"Ana Sayfa Sertifikal\u0131 Kutu A\u00e7\u0131klamas\u0131","home_page_certified_box_title":"Ana Sayfa Sertifikal\u0131 Kutu Ba\u015fl\u0131\u011f\u0131","home_page_certified_doctor_description":"Ana Sayfa Sertifikal\u0131 Doktor A\u00e7\u0131klamas\u0131","home_page_certified_doctor_text":"Ana Sayfa Sertifikal\u0131 Doktor Metni","home_page_certified_doctor_title":"Home Page Certified Doctor Title","home_page_description":"Ana Sayfa A\u00e7\u0131klama","home_page_experience":"Ana Sayfa Deneyimi","home_page_step_1_description":"Ana Sayfa Ad\u0131m 1 A\u00e7\u0131klama","home_page_step_1_title":"Ana Sayfa Ad\u0131m 1 Ba\u015fl\u0131k","home_page_step_2_description":"Ana Sayfa Ad\u0131m 2 A\u00e7\u0131klama","home_page_step_2_title":"Ana Sayfa Ad\u0131m 2 Ba\u015fl\u0131k","home_page_step_3_description":"Ana Sayfa Ad\u0131m 3 A\u00e7\u0131klama","home_page_step_3_title":"Ana Sayfa Ad\u0131m 3 Ba\u015fl\u0131k","home_page_step_4_description":"Ana Sayfa Ad\u0131m 4 A\u00e7\u0131klama","home_page_step_4_title":"Ana Sayfa Ad\u0131m 4 Ba\u015fl\u0131k","home_page_title":"Ana Sayfa Ba\u015fl\u0131\u011f\u0131","image_must_be":"Resim \u015fu t\u00fcrde bir dosya olmal\u0131d\u0131r: jpg, jpeg, png.","invalid_country_code":"Ge\u00e7ersiz numara","invalid_number":"Ge\u00e7ersiz numara","ipd_timeline":"IPD Zaman \u00c7izelgesi","item_returned":"\u00d6\u011fe ba\u015far\u0131yla geri d\u00f6nd\u00fc.","jan":"Ocak","jul":"Temmuz","jun":"Haziran","last_30_days":"Son 30 g\u00fcn","last_7_days":"Son 7 g\u00fcn","last_month":"Ge\u00e7en ay","lunch_break":"K\u0131rmak","mar":"Mart","may":"May\u0131s","medicine_bill":"\u0130la\u00e7 Yasas\u0131","medicine_bill_already_use":"Bu ila\u00e7 zaten ila\u00e7 faturalar\u0131nda kullan\u0131l\u0131yor, silmek istedi\u011finizden emin misiniz?","medicine_required":"T\u0131p alan\u0131 zorunludur.","mon":"PZT","monday":"Pazartesi","net_amount_not_empty":"Net tutar bo\u015f olamaz.","net_amount_not_zero":"Net tutar s\u0131f\u0131r olamaz.","no_ipd_patient_found":"Hi\u00e7bir IPD Hastas\u0131 Bulunamad\u0131","notification_read":"Bildirim ba\u015far\u0131yla okundu.","nov":"Kas\u0131m","oct":"Ekim","paid":"Paral\u0131","password_not_match":"\u015eifre ve \u015eifreyi onayla e\u015fle\u015fmiyor.","patient_not_exists_or_status_is_not_active":"Hasta mevcut de\u011fil veya durumu aktif de\u011fil.","patient_required":"Hasta alan\u0131 zorunludur.","paypal_client_id":"Paypal M\u00fc\u015fteri Kimli\u011fi","paypal_mode":"L\u00fctfen paypal moduna girin.","paypal_secret":"L\u00fctfen paypal s\u0131rr\u0131n\u0131z\u0131 girin.","paystack_key":"L\u00fctfen paystack genel anahtar\u0131n\u0131 girin.","paystack_secret":"L\u00fctfen \u00f6deme y\u0131\u011f\u0131n\u0131 gizli Anahtar\u0131n\u0131 girin.","paytm_id":"L\u00fctfen paytm sat\u0131c\u0131 kimli\u011fini girin.","paytm_key":"L\u00fctfen paytm sat\u0131c\u0131 anahtar\u0131n\u0131 girin.","phone_number":"Google Captcha S\u0131rr\u0131","please_enter_valid_Instagram_url":"L\u00fctfen ge\u00e7erli bir Instagram URL'si girin","please_enter_valid_facebook_url":"L\u00fctfen ge\u00e7erli bir Facebook URL'si girin","please_enter_valid_linkedin_url":"L\u00fctfen ge\u00e7erli bir LinkedIn URL'si girin","please_enter_valid_twitter_url":"L\u00fctfen ge\u00e7erli bir Twitter URL'si girin","please_select_doctor":"L\u00fctfen Doktor se\u00e7iniz","privacy_policy":"Gizlilik Politikas\u0131","purchase_medicine":"\u0130la\u00e7 Sat\u0131n Al\u0131n","qr_code_not_found":"QR kodu bulunamad\u0131.","qty_cannot_be_zero":"Miktar s\u0131f\u0131r olamaz.","qty_must_be_less_than_available_qty":"Miktar, Mevcut miktardan az olmal\u0131d\u0131r.","quantity_greater_than_0":"Miktar 0'dan b\u00fcy\u00fck olmal\u0131d\u0131r.","quantity_not_empty":"Miktar s\u0131f\u0131r veya bo\u015f olamaz.","razor_pay_secret":"L\u00fctfen razorpay Secret'\u0131 girin.","razorpay_key":"L\u00fctfen razorpay anahtar\u0131n\u0131 girin.","sat":"DOYGUNLUK","saturday":"Cumartesi","select_account":"Hesap Se\u00e7in","select_appointment_date":"L\u00fctfen randevu tarihini se\u00e7iniz.","select_bed_type":"Yatak Tipini Se\u00e7in","select_calendar":"L\u00fctfen bir takvim se\u00e7in.","select_category":"Kategori se\u00e7","select_charge":"\u015earj Se\u00e7in","select_charge_category":"\u00dccret Kategorisini Se\u00e7in","select_charge_type":"Kategori T\u00fcr\u00fcn\u00fc Se\u00e7in","select_code":"Kod Se\u00e7in","select_doctor":"Doktor Se\u00e7in","select_doctors":"Doktorlar\u0131 Se\u00e7in","select_dose_interval":"Doz Aral\u0131\u011f\u0131n\u0131 Se\u00e7in","select_duration":"S\u00fcreyi Se\u00e7in","select_employee":"\u00c7al\u0131\u015fan Se\u00e7in","select_ipd_patient":"IPD Hastas\u0131n\u0131 Se\u00e7in","select_item":"\u00d6\u011feyi se\u00e7in","select_medicine":"T\u0131p Se\u00e7iniz","select_parameter_name":"Hizmet Se\u00e7in","select_patient":"Hasta Se\u00e7","select_service":"Hizmet Se\u00e7in","select_time_slot":"L\u00fctfen randevu saat aral\u0131\u011f\u0131n\u0131 se\u00e7iniz.","select_type_number":"Tip Numaras\u0131n\u0131 Se\u00e7in","select_user":"Kullan\u0131c\u0131 se\u00e7","send_mail":"Posta g\u00f6ndermek","sending":"G\u00f6nderiliyor...","sep":"Eyl\u00fcl","smart_patient_card":"Hasta Ak\u0131ll\u0131 Kart\u0131","status":"Durum","stripe_key":"L\u00fctfen Stripe Secret'a girin.","stripe_secret":"\u015eerit S\u0131rr\u0131","sun":"G\u00dcNE\u015e","sunday":"Pazar","tax_less_100":"Vergiler %100'den az olmal\u0131d\u0131r.","tax_not_empty":"Vergi tutar\u0131 s\u0131f\u0131r veya bo\u015f olamaz.","template_required":"\u015eablon Ad\u0131 alan\u0131 zorunludur.","terms_condition_required":"\u015eartlar ve Ko\u015fullar gereklidir.","terms_conditions":"\u00c7al\u0131\u015fan Se\u00e7in","this_month":"Bu ay","this_week":"Bu hafta","thu":"per\u015f","thursday":"Per\u015fembe","to":"\u0130le","today":"Bug\u00fcn","too_long":"\u00c7ok uzun","too_short":"\u00c7ok k\u0131sa","tue":"SALI","tuesday":"Sal\u0131","u_want_to_complete_this_payment":"Bu \u00f6demeyi tamamlamak istiyorsunuz!","unpaid":"\u00f6denmemi\u015f","update_quantity":"G\u00fcncelleme miktar\u0131 \u00f6nceki miktardan az olmal\u0131d\u0131r.","value_field_required":"De\u011fer alan\u0131 zorunludur.","value_must_be_greter_then":"De\u011fer 1'den b\u00fcy\u00fck olmal\u0131d\u0131r","warning":"Uyar\u0131 !","wed":"EVLENMEK","wednesday":"\u00c7ar\u015famba","yesterday":"D\u00fcn","your_payment_failed":"\u00d6demeniz ba\u015far\u0131s\u0131z oldu.","zoom":"Yak\u0131nla\u015ft\u0131r"},"zh.js":{"about_us_description":"\u63cf\u8ff0","about_us_mission":"\u4f7f\u547d","about_us_title":"\u6a19\u984c","active":"\u7a4d\u6975\u7684","all_notification_read":"\u6240\u6709\u901a\u77e5\u8b80\u53d6\u6210\u529f\u3002","all_required_fields":"\u8acb\u586b\u5beb\u6240\u6709\u5fc5\u586b\u6b04\u4f4d\u3002","apply":"\u7533\u8acb","appointment":"\u9810\u7d04","appointment_cancel":"\u9810\u7d04\u53d6\u6d88\u6210\u529f\u3002","apr":"\u56db\u6708","are_u_sure":"\u4f60\u78ba\u5b9a\u55ce\uff1f","are_you_sure_want_to_cancel":"\u60a8\u78ba\u5b9a\u8981\u53d6\u6d88\u55ce","are_you_sure_want_to_change":"\u4f60\u78ba\u5b9a\u8981\u6539\u8b8a\u55ce ","are_you_sure_want_to_delete_this":"\u60a8\u78ba\u5b9a\u8981\u522a\u9664\u6b64\u5167\u5bb9\u55ce ","are_you_sure_want_to_return_this_item":"\u60a8\u78ba\u5b9a\u8981\u9000\u56de\u8a72\u5546\u54c1\u55ce","aug":"\u516b\u6708","available_quantity":"\u53ef\u7528\u6578\u91cf","break_time_greater_than_zero":"\u4e2d\u65b7\u6642\u9593\u5fc5\u9808\u5927\u65bc\u96f6","break_to_time_greater_than_from_time":"Break To \u6642\u9593\u5fc5\u9808\u5927\u65bc Break From \u6642\u9593\u3002","break_to_time_greater_than_zero":"Break To \u6642\u9593\u5fc5\u9808\u5927\u65bc\u96f6","cancel":"Cancel","canceled":"\u53d6\u6d88","captcha_key":"Google\u9a57\u8b49\u78bc\u91d1\u9470","captcha_secret":"\u8c37\u6b4c\u9a57\u8b49\u78bc\u7684\u79d8\u5bc6","card_template":"\u60a3\u8005\u667a\u6167\u5361\u6a21\u677f","change_status":"\u66f4\u6539\u72c0\u614b","changed_appointment":"\u66f4\u6539\u9810\u7d04","charchter_160":"\u8a72\u8a0a\u606f\u4e0d\u5f97\u8d85\u904e 160 \u500b\u5b57\u5143\u3002","choose_bed":"\u9078\u64c7\u5e8a\u4f4d","choose_case":"\u9078\u64c7\u6848\u4f8b","currency":"\u8ca8\u5e63","custom":"\u98a8\u4fd7","date_required":"\u65e5\u671f\u6b04\u4f4d\u70ba\u5fc5\u586b\u9805","deactive":"\u6b78\u7d0d\u6cd5","dec":"\u5341\u4e8c\u6708","deduction_not_greater_than_salary":"\u6263\u9664\u984d\u4e0d\u80fd\u5927\u65bc\u57fa\u672c\u5de5\u8cc7+\u6d25\u8cbc","deleted":"\u5df2\u522a\u9664","department":"\u90e8\u9580","disconnect_or_reconnect":"\u8acb\u4e2d\u65b7\u4e26\u91cd\u65b0\u9023\u63a5\u60a8\u7684 Google \u65e5\u66c6","discount_less_than_amount":"\u6298\u6263\u61c9\u5c0f\u65bc\u7e3d\u91d1\u984d\u3002","doctor_schedule_not_available_on_this_date":"\u8a72\u65e5\u671f\u6c92\u6709\u91ab\u751f\u6642\u9593\u8868\u3002","document_file_size":"\u8a72\u6587\u4ef6\u5fc5\u9808\u662f\u4ee5\u4e0b\u985e\u578b\u7684\u6587\u4ef6\uff1ajpeg\u3001jpg\u3001png\u3001pdf\u3001doc\u3001docx\u3001mp3\u3001mp4","document_must_be_file_type":"\u8a72\u6587\u4ef6\u5fc5\u9808\u662f\u4ee5\u4e0b\u985e\u578b\u7684\u6587\u4ef6\uff1ajpeg\u3001jpg\u3001png\u3001pdf\u3001doc\u3001docx\u3002","enter_lot_no":"\u8f38\u5165\u6279\u865f\u3002","enter_purchase_price":"\u8f38\u5165\u8cfc\u8cb7\u50f9\u683c\u3002","enter_sale_price":"\u8f38\u5165\u92b7\u552e\u50f9\u683c\u3002","feb":"\u4e8c\u6708","field_not_contain_white_space":"\u5b57\u6bb5\u4e0d\u50c5\u50c5\u5305\u542b\u7a7a\u683c","field_required":"\u5b57\u6bb5\u4e3a\u5fc5\u586b\u5b57\u6bb5\u3002","fri":"\u5f17\u745e","friday":"\u661f\u671f\u4e94","from":"\u5f9e","google_meet":"Google\u898b\u9762","has_been_changed":"\u5df2\u7d93\u8b8a\u4e86\u3002","has_been_deleted":"\u5df2\u522a\u9664\u3002","holiday":"\u5047\u671f","home_page_box_description":"\u4e3b\u9801\u6846\u8aaa\u660e","home_page_box_title":"\u4e3b\u9801\u6846\u6a19\u984c","home_page_certified_box_description":"\u9996\u9801 \u8a8d\u8b49\u76d2\u8aaa\u660e","home_page_certified_box_title":"\u4e3b\u9801\u8a8d\u8b49\u6846\u6a19\u984c","home_page_certified_doctor_description":"\u4e3b\u9801\u8a8d\u8b49\u91ab\u751f\u8aaa\u660e","home_page_certified_doctor_text":"\u4e3b\u9801\u8a8d\u8b49\u91ab\u751f\u6587\u672c","home_page_certified_doctor_title":"\u9996\u9801 \u8a8d\u8b49\u91ab\u5e2b\u8077\u7a31","home_page_description":"\u9996\u9801\u8aaa\u660e","home_page_experience":"\u9996\u9801\u9ad4\u9a57","home_page_step_1_description":"\u9996\u9801\u6b65\u9a5f 1 \u8aaa\u660e","home_page_step_1_title":"\u9996\u9801\u6b65\u9a5f 1 \u6a19\u984c","home_page_step_2_description":"\u9996\u9801\u6b65\u9a5f 2 \u8aaa\u660e","home_page_step_2_title":"\u9996\u9801\u6b65\u9a5f 2 \u6a19\u984c","home_page_step_3_description":"\u9996\u9801\u6b65\u9a5f 3 \u8aaa\u660e","home_page_step_3_title":"\u9996\u9801\u6b65\u9a5f 3 \u6a19\u984c","home_page_step_4_description":"\u9996\u9801\u6b65\u9a5f 4 \u8aaa\u660e","home_page_step_4_title":"\u9996\u9801\u7b2c 4 \u6b65\u6a19\u984c","home_page_title":"\u9996\u9801\u6a19\u984c","image_must_be":"\u5716\u50cf\u5fc5\u9808\u662f\u4ee5\u4e0b\u985e\u578b\u7684\u6a94\u6848\uff1ajpg\u3001jpeg\u3001png\u3002","invalid_country_code":"\u570b\u5bb6\u4ee3\u78bc\u7121\u6548","invalid_number":"\u7121\u6548\u865f\u78bc","ipd_timeline":"IPD \u6642\u9593\u8868","item_returned":"\u7269\u54c1\u6210\u529f\u8fd4\u56de\u3002","jan":"\u4e00\u6708","jul":"\u4e03\u6708","jun":"\u516d\u6708","last_30_days":"\u904e\u53bb 30 \u5929","last_7_days":"\u904e\u53bb 7 \u5929","last_month":"\u4e0a\u500b\u6708","lunch_break":"\u4f11\u606f","mar":"\u884c\u9032","may":"\u53ef\u80fd","medicine_bill":"\u91ab\u85e5\u6cd5\u6848","medicine_bill_already_use":"\u8a72\u85e5\u5df2\u5728\u91ab\u85e5\u5e33\u55ae\u4e2d\u4f7f\u7528\uff0c\u60a8\u78ba\u5b9a\u8981\u522a\u9664\u55ce\uff1f","medicine_required":"\u9700\u8981\u91ab\u5b78\u9818\u57df\u3002","mon":"\u9031\u4e00","monday":"\u9031\u4e00","net_amount_not_empty":"\u6de8\u984d\u4e0d\u80fd\u70ba\u7a7a\u3002","net_amount_not_zero":"\u6de8\u984d\u4e0d\u80fd\u70ba\u96f6\u3002","no_ipd_patient_found":"\u672a\u627e\u5230 IPD \u60a3\u8005","notification_read":"\u901a\u77e5\u8b80\u53d6\u6210\u529f\u3002","nov":"\u5341\u4e00\u6708","oct":"\u5341\u6708","paid":"\u6709\u85aa\u8cc7\u7684","password_not_match":"\u5bc6\u78bc\u548c\u78ba\u8a8d\u5bc6\u78bc\u4e0d\u7b26\u3002","patient_not_exists_or_status_is_not_active":"\u60a3\u8005\u4e0d\u5b58\u5728\u6216\u72c0\u614b\u4e0d\u6d3b\u8e8d\u3002","patient_required":"\u9700\u8981\u60a3\u8005\u5b57\u6bb5\u3002","paypal_client_id":"\u8c9d\u5bf6\u5ba2\u6236 ID","paypal_mode":"\u8acb\u9032\u5165\u8c9d\u5bf6\u6a21\u5f0f\u3002","paypal_secret":"\u8acb\u8f38\u5165\u8c9d\u5bf6\u5bc6\u78bc\u3002","paystack_key":"\u8acb\u8f38\u5165 Paystack \u516c\u9470\u3002","paystack_secret":"\u8acb\u8f38\u5165 Paystack \u5bc6\u9470\u3002","paytm_id":"\u8acb\u8f38\u5165 paytm \u5546\u5bb6 ID\u3002","paytm_key":"\u8acb\u8f38\u5165 paytm \u5546\u5bb6\u91d1\u9470\u3002","phone_number":"\u96fb\u8a71\u865f\u78bc","please_enter_valid_Instagram_url":"\u8acb\u8f38\u5165\u6709\u6548\u7684 Instagram \u7db2\u5740","please_enter_valid_facebook_url":"\u8acb\u8f38\u5165\u6709\u6548\u7684 Facebook \u7db2\u5740","please_enter_valid_linkedin_url":"\u8acb\u8f38\u5165\u6709\u6548\u7684 LinkedIn \u7db2\u5740","please_enter_valid_twitter_url":"\u8acb\u8f38\u5165\u6709\u6548\u7684 Twitter \u7db2\u5740","please_select_doctor":"\u8acb\u9078\u64c7\u91ab\u751f","privacy_policy":"\u96b1\u79c1\u6b0a\u653f\u7b56","purchase_medicine":"\u7a05\u984d\u4e0d\u80fd\u70ba\u96f6\u6216\u70ba\u7a7a\u3002","qr_code_not_found":"\u672a\u627e\u5230\u4e8c\u7dad\u78bc\u3002","qty_cannot_be_zero":"\u6578\u91cf\u4e0d\u80fd\u70ba\u96f6\u3002","qty_must_be_less_than_available_qty":"\u6578\u91cf\u5fc5\u9808\u5c0f\u65bc\u53ef\u7528\u6578\u91cf\u3002","quantity_greater_than_0":"\u6578\u91cf\u61c9\u5927\u65bc 0\u3002","quantity_not_empty":"\u6578\u91cf\u4e0d\u80fd\u70ba\u96f6\u6216\u70ba\u7a7a\u3002","razor_pay_secret":"\u8acb\u8f38\u5165razorpay\u79d8\u5bc6\u3002","razorpay_key":"\u8acb\u8f38\u5165razorpay\u5bc6\u9470\u3002","sat":"SAT","saturday":"\u9031\u516d","select_account":"\u9078\u64c7\u5e33\u6236","select_appointment_date":"\u8acb\u9078\u64c7\u9810\u7d04\u65e5\u671f\u3002","select_bed_type":"\u9078\u64c7\u5e8a\u578b","select_calendar":"\u8acb\u9078\u64c7\u65e5\u66c6\u3002","select_category":"\u9078\u64c7\u985e\u5225","select_charge":"\u9078\u64c7\u6536\u8cbb","select_charge_category":"\u9078\u64c7\u6536\u8cbb\u985e\u5225","select_charge_type":"\u9078\u64c7\u985e\u5225\u985e\u578b","select_code":"\u9078\u64c7\u4ee3\u78bc","select_doctor":"\u9078\u64c7\u91ab\u751f","select_doctors":"\u9078\u64c7\u91ab\u751f","select_dose_interval":"\u9078\u64c7\u5291\u91cf\u9593\u9694","select_duration":"\u9078\u64c7\u6301\u7e8c\u6642\u9593","select_employee":"\u9078\u64c7\u54e1\u5de5","select_ipd_patient":"\u9078\u64c7 IPD \u60a3\u8005","select_item":"\u9078\u64c7\u7269\u54c1","select_medicine":"\u9078\u64c7\u85e5\u7269","select_parameter_name":"\u9078\u64c7\u53c3\u6578\u540d\u7a31","select_patient":"\u9078\u64c7\u60a3\u8005","select_service":"\u9078\u64c7\u670d\u52d9","select_time_slot":"\u8acb\u9078\u64c7\u9810\u7d04\u6642\u6bb5\u3002","select_type_number":"\u9078\u64c7\u985e\u578b\u7de8\u865f","select_user":"\u9078\u64c7\u7528\u6236","send_mail":"\u50b3\u9001\u90f5\u4ef6","sending":"\u6b63\u5728\u767c\u9001...","sep":"\u4e5d\u6708","smart_patient_card":"\u60a3\u8005\u667a\u6167\u5361","status":"\u5730\u4f4d","stripe_key":"\u8acb\u8f38\u5165\u689d\u7d0b\u79d8\u5bc6\u3002","stripe_secret":"\u689d\u7d0b\u7684\u79d8\u5bc6","sun":"\u592a\u967d","sunday":"\u661f\u671f\u65e5","tax_less_100":"\u7a05\u6536\u61c9\u4f4e\u65bc 100%\u3002","tax_not_empty":"\u7a05\u984d\u4e0d\u80fd\u70ba\u96f6\u6216\u70ba\u7a7a\u3002","template_required":"\u6a21\u677f\u540d\u7a31\u6b04\u4f4d\u662f\u5fc5\u9700\u7684\u3002","terms_condition_required":"\u689d\u6b3e\u548c\u689d\u4ef6\u70ba\u5fc5\u586b\u9805\u3002","terms_conditions":"\u689d\u6b3e\u53ca\u689d\u4ef6","this_month":"\u9019\u500b\u6708","this_week":"\u672c\u661f\u671f","thu":"\u9031\u56db","thursday":"\u9031\u56db","to":"\u5230","today":"\u4eca\u5929","too_long":"\u592a\u9577","too_short":"\u904e\u77ed","tue":"\u6cbb\u7642\u8cbb\u7528","tuesday":"\u9031\u4e8c","u_want_to_complete_this_payment":"\u60a8\u60f3\u5b8c\u6210\u9019\u7b46\u6b3e\u9805\uff01","unpaid":"\u672a\u4ed8","update_quantity":"\u66f4\u65b0\u6578\u91cf\u61c9\u5c0f\u65bc\u4e4b\u524d\u7684\u6578\u91cf\u3002","value_field_required":"\u503c\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","value_must_be_greter_then":"\u503c\u5fc5\u987b\u5927\u4e8e 1","warning":"\u8b66\u544a \uff01","wed":"\u661f\u671f\u4e09","wednesday":"\u9031\u4e09","yesterday":"\u6628\u5929","your_payment_failed":"\u60a8\u7684\u4ed8\u6b3e\u5931\u6557\u3002","zoom":"\u98db\u6f32"}});
})();
