export default function useLanguageCodeConversion() {
    const languageCodeMapping: Record<string, string> = {
        'af': 'af-ZA',
        'am': 'am-ET',
        'ar': 'ar-SA',
        'az': 'az-AZ',
        'be': 'be-BY',
        'bg': 'bg-BG',
        'bn': 'bn-BD',
        'bs': 'bs-BA',
        'ca': 'ca-ES',
        'ceb': 'ceb-PH',
        'cs': 'cs-CZ',
        'cy': 'cy-GB',
        'da': 'da-DK',
        'de': 'de-DE',
        'el': 'el-GR',
        'en': 'en-US',
        'es': 'es-ES',
        'et': 'et-EE',
        'eu': 'eu-ES',
        'fa': 'fa-IR',
        'fi': 'fi-FI',
        'fil': 'fil',
        'fr': 'fr-FR',
        'ga': 'ga-IE',
        'gl': 'gl-ES',
        'gu': 'gu-IN',
        'ha': 'ha-NG',
        'he': 'he-IL',
        'hi': 'hi-IN',
        'hr': 'hr-HR',
        'ht': 'ht-HT',
        'hu': 'hu-HU',
        'hy': 'hy-AM',
        'id': 'id-ID',
        'ig': 'ig-NG',
        'is': 'is-IS',
        'it': 'it-IT',
        'ja': 'ja-JP',
        'jv': 'jv-ID',
        'ka': 'ka-GE',
        'kk': 'kk-KZ',
        'km': 'km-KH',
        'kn': 'kn-IN',
        'ko': 'ko-KR',
        'ku': 'ku-TR',
        'ky': 'ky-KG',
        'lo': 'lo-LA',
        'lt': 'lt-LT',
        'lv': 'lv-LV',
        'mk': 'mk-MK',
        'ml': 'ml-IN',
        'mn': 'mn-MN',
        'mr': 'mr-IN',
        'ms': 'ms-MY',
        'mt': 'mt-MT',
        'ne': 'ne-NP',
        'nl': 'nl-NL',
        'no': 'nb-NO',
        'pa': 'pa-IN',
        'pl': 'pl-PL',
        'ps': 'ps-AF',
        'pt': 'pt-BR',
        'pt-br': 'pt-BR',
        'ro': 'ro-RO',
        'ru': 'ru-RU',
        'sd': 'sd-PK',
        'si': 'si-LK',
        'sk': 'sk-SK',
        'sl': 'sl-SI',
        'so': 'so-SO',
        'sq': 'sq-AL',
        'sr': 'sr-RS',
        'st': 'st-ZA',
        'su': 'su-ID',
        'sv': 'sv-SE',
        'sw': 'sw-TZ',
        'ta': 'ta-IN',
        'te': 'te-IN',
        'tg': 'tg-TJ',
        'th': 'th-TH',
        'tr': 'tr-TR',
        'uk': 'uk-UA',
        'ur': 'ur-PK',
        'uz': 'uz-UZ',
        'vi': 'vi-VN',
        'xh': 'xh-ZA',
        'yo': 'yo-NG',
        'zh': 'zh-CN',
        'zh-tw': 'zh-TW',
        'zu': 'zu-ZA',
    };

    function convertLanguageCode(shortCode: string): string | null {
        return languageCodeMapping[shortCode] || null;
    }

    return {
        convertLanguageCode,
    };
}
