<?php

namespace Tapp\FilamentCountryCodeField\Enums;

enum CountriesEnum: string
{
    case AF = 'af';
    case AL = 'al';
    case DZ = 'dz';
    case AS = 'as';
    case AD = 'ad';
    case AO = 'ao';
    case AI = 'ai';
    case AG = 'ag';
    case AR = 'ar';
    case AM = 'am';
    case AW = 'aw';
    case AU = 'au';
    case AT = 'at';
    case AZ = 'az';
    case BS = 'bs';
    case BH = 'bh';
    case BD = 'bd';
    case BB = 'bb';
    case BY = 'by';
    case BE = 'be';
    case BZ = 'bz';
    case BJ = 'bj';
    case BM = 'bm';
    case BT = 'bt';
    case BO = 'bo';
    case BA = 'ba';
    case BW = 'bw';
    case BR = 'br';
    case BN = 'bn';
    case BG = 'bg';
    case BF = 'bf';
    case BI = 'bi';
    case CV = 'cv';
    case KH = 'kh';
    case CM = 'cm';
    // case CA = 'ca';
    case KY = 'ky';
    case CF = 'cf';
    case TD = 'td';
    case CL = 'cl';
    case CN = 'cn';
    case CO = 'co';
    case KM = 'km';
    case CD = 'cd';
    case CK = 'ck';
    case CR = 'cr';
    case CI = 'ci';
    case HR = 'hr';
    case CU = 'cu';
    case CW = 'cw';
    case CY = 'cy';
    case CZ = 'cz';
    case DK = 'dk';
    case DJ = 'dj';
    case DM = 'dm';
    case DO = 'do';
    case EC = 'ec';
    case EG = 'eg';
    case SV = 'sv';
    case GQ = 'gq';
    case ER = 'er';
    case EE = 'ee';
    case ET = 'et';
    case FJ = 'fj';
    case FI = 'fi';
    case FR = 'fr';
    case GA = 'ga';
    case GM = 'gm';
    case GE = 'ge';
    case DE = 'de';
    case GH = 'gh';
    case GI = 'gi';
    case GR = 'gr';
    case GD = 'gd';
    case GU = 'gu';
    case GT = 'gt';
    case GG = 'gg';
    case GN = 'gn';
    case GW = 'gw';
    case GY = 'gy';
    case HT = 'ht';
    case HN = 'hn';
    case HK = 'hk';
    case HU = 'hu';
    case IS = 'is';
    case IN = 'in';
    case ID = 'id';
    case IR = 'ir';
    case IQ = 'iq';
    case IE = 'ie';
    case IM = 'im';
    case IL = 'il';
    case IT = 'it';
    case JM = 'jm';
    case JP = 'jp';
    case JE = 'je';
    case JO = 'jo';
    // case KZ = 'kz';
    case KE = 'ke';
    case KP = 'kp';
    case KR = 'kr';
    case XK = 'xk';
    case KW = 'kw';
    case KG = 'kg';
    case LA = 'la';
    case LV = 'lv';
    case LB = 'lb';
    case LS = 'ls';
    case LR = 'lr';
    case LY = 'ly';
    case LI = 'li';
    case LT = 'lt';
    case LU = 'lu';
    case MG = 'mg';
    case MW = 'mw';
    case MY = 'my';
    case MV = 'mv';
    case ML = 'ml';
    case MT = 'mt';
    case MH = 'mh';
    case MR = 'mr';
    case MU = 'mu';
    case MX = 'mx';
    case MD = 'md';
    case MC = 'mc';
    case MN = 'mn';
    case ME = 'me';
    case MS = 'ms';
    case MA = 'ma';
    case MZ = 'mz';
    case MM = 'mm';
    case NA = 'na';
    case NR = 'nr';
    case NP = 'np';
    case NL = 'nl';
    case NZ = 'nz';
    case NI = 'ni';
    case NE = 'ne';
    case NG = 'ng';
    case NU = 'nu';
    case MK = 'mk';
    case NO = 'no';
    case OM = 'om';
    case PK = 'pk';
    case PW = 'pw';
    case PS = 'ps';
    case PA = 'pa';
    case PG = 'pg';
    case PY = 'py';
    case PE = 'pe';
    case PH = 'ph';
    case PL = 'pl';
    case PT = 'pt';
    case QA = 'qa';
    case RO = 'ro';
    case RU_KZ = 'ru_kz';
    case RW = 'rw';
    case KN = 'kn';
    case LC = 'lc';
    case VC = 'vc';
    case WS = 'ws';
    case SM = 'sm';
    case ST = 'st';
    case SA = 'sa';
    case SN = 'sn';
    case RS = 'rs';
    case SC = 'sc';
    case SL = 'sl';
    case SG = 'sg';
    case SX = 'sx';
    case SK = 'sk';
    case SI = 'si';
    case SB = 'sb';
    case SO = 'so';
    case ZA = 'za';
    case SS = 'ss';
    case ES = 'es';
    case LK = 'lk';
    case SD = 'sd';
    case SR = 'sr';
    case SZ = 'sz';
    case SE = 'se';
    case CH = 'ch';
    case SY = 'sy';
    case TW = 'tw';
    case TJ = 'tj';
    case TZ = 'tz';
    case TH = 'th';
    case TG = 'tg';
    case TO = 'to';
    case TT = 'tt';
    case TN = 'tn';
    case TR = 'tr';
    case TM = 'tm';
    case TC = 'tc';
    case UG = 'ug';
    case UA = 'ua';
    case AE = 'ae';
    case GB = 'gb';
    case US_CA = 'us_ca';
    case UY = 'uy';
    case UZ = 'uz';
    case VU = 'vu';
    case VE = 've';
    case VN = 'vn';
    case VG = 'vg';
    case VI = 'vi';
    case YE = 'ye';
    case ZM = 'zm';
    case ZW = 'zw';

    public function getLabel(): string
    {
        return __('filament-country-code-field::countries.'.$this->value);
    }

    public function getCountryCode(): string
    {
        return match ($this) {
            self::AF => '+93',
            self::AL => '+355',
            self::DZ => '+213',
            self::AS => '+1-684',
            self::AD => '+376',
            self::AO => '+244',
            self::AI => '+1-264',
            self::AG => '+1-268',
            self::AR => '+54',
            self::AM => '+374',
            self::AW => '+297',
            self::AU => '+61',
            self::AT => '+43',
            self::AZ => '+994',
            self::BS => '+1-242',
            self::BH => '+973',
            self::BD => '+880',
            self::BB => '+1-246',
            self::BY => '+375',
            self::BE => '+32',
            self::BZ => '+501',
            self::BJ => '+229',
            self::BM => '+1-441',
            self::BT => '+975',
            self::BO => '+591',
            self::BA => '+387',
            self::BW => '+267',
            self::BR => '+55',
            self::BN => '+673',
            self::BG => '+359',
            self::BF => '+226',
            self::BI => '+257',
            self::CV => '+238',
            self::KH => '+855',
            self::CM => '+237',
            // self::CA => '+1',
            self::KY => '+1-345',
            self::CF => '+236',
            self::TD => '+235',
            self::CL => '+56',
            self::CN => '+86',
            self::CO => '+57',
            self::KM => '+269',
            self::CD => '+243',
            self::CK => '+682',
            self::CR => '+506',
            self::CI => '+225',
            self::HR => '+385',
            self::CU => '+53',
            self::CW => '+599',
            self::CY => '+357',
            self::CZ => '+420',
            self::DK => '+45',
            self::DJ => '+253',
            self::DM => '+1-767',
            self::DO => '+1-809, 1-829, 1-849',
            self::EC => '+593',
            self::EG => '+20',
            self::SV => '+503',
            self::GQ => '+240',
            self::ER => '+291',
            self::EE => '+372',
            self::ET => '+251',
            self::FJ => '+679',
            self::FI => '+358',
            self::FR => '+33',
            self::GA => '+241',
            self::GM => '+220',
            self::GE => '+995',
            self::DE => '+49',
            self::GH => '+233',
            self::GI => '+350',
            self::GR => '+30',
            self::GD => '+1-473',
            self::GU => '+1-671',
            self::GT => '+502',
            self::GG => '+44-1481',
            self::GN => '+224',
            self::GW => '+245',
            self::GY => '+592',
            self::HT => '+509',
            self::HN => '+504',
            self::HK => '+852',
            self::HU => '+36',
            self::IS => '+354',
            self::IN => '+91',
            self::ID => '+62',
            self::IR => '+98',
            self::IQ => '+964',
            self::IE => '+353',
            self::IM => '+44-1624',
            self::IL => '+972',
            self::IT => '+39',
            self::JM => '+1-876',
            self::JP => '+81',
            self::JE => '+44-1534',
            self::JO => '+962',
            // self::KZ => '+7',
            self::KE => '+254',
            self::KP => '+850',
            self::KR => '+82',
            self::XK => '+383',
            self::KW => '+965',
            self::KG => '+996',
            self::LA => '+856',
            self::LV => '+371',
            self::LB => '+961',
            self::LS => '+266',
            self::LR => '+231',
            self::LY => '+218',
            self::LI => '+423',
            self::LT => '+370',
            self::LU => '+352',
            self::MG => '+261',
            self::MW => '+265',
            self::MY => '+60',
            self::MV => '+960',
            self::ML => '+223',
            self::MT => '+356',
            self::MH => '+692',
            self::MR => '+222',
            self::MU => '+230',
            self::MX => '+52',
            self::MD => '+373',
            self::MC => '+377',
            self::MN => '+976',
            self::ME => '+382',
            self::MS => '+1-664',
            self::MA => '+212',
            self::MZ => '+258',
            self::MM => '+95',
            self::NA => '+264',
            self::NR => '+674',
            self::NP => '+977',
            self::NL => '+31',
            self::NZ => '+64',
            self::NI => '+505',
            self::NE => '+227',
            self::NG => '+234',
            self::NU => '+683',
            self::MK => '+389',
            self::NO => '+47',
            self::OM => '+968',
            self::PK => '+92',
            self::PW => '+680',
            self::PS => '+970',
            self::PA => '+507',
            self::PG => '+675',
            self::PY => '+595',
            self::PE => '+51',
            self::PH => '+63',
            self::PL => '+48',
            self::PT => '+351',
            self::QA => '+974',
            self::RO => '+40',
            self::RU_KZ => '+7',
            self::RW => '+250',
            self::KN => '+1-869',
            self::LC => '+1-758',
            self::VC => '+1-784',
            self::WS => '+685',
            self::SM => '+378',
            self::ST => '+239',
            self::SA => '+966',
            self::SN => '+221',
            self::RS => '+381',
            self::SC => '+248',
            self::SL => '+232',
            self::SG => '+65',
            self::SX => '+1-721',
            self::SK => '+421',
            self::SI => '+386',
            self::SB => '+677',
            self::SO => '+252',
            self::ZA => '+27',
            self::SS => '+211',
            self::ES => '+34',
            self::LK => '+94',
            self::SD => '+249',
            self::SR => '+597',
            self::SZ => '+268',
            self::SE => '+46',
            self::CH => '+41',
            self::SY => '+963',
            self::TW => '+886',
            self::TJ => '+992',
            self::TZ => '+255',
            self::TH => '+66',
            self::TG => '+228',
            self::TO => '+676',
            self::TT => '+1-868',
            self::TN => '+216',
            self::TR => '+90',
            self::TM => '+993',
            self::TC => '+1-649',
            self::UG => '+256',
            self::UA => '+380',
            self::AE => '+971',
            self::GB => '+44',
            self::US_CA => '+1',
            self::UY => '+598',
            self::UZ => '+998',
            self::VU => '+678',
            self::VE => '+58',
            self::VN => '+84',
            self::VG => '+1-284',
            self::VI => '+1-340',
            self::YE => '+967',
            self::ZM => '+260',
            self::ZW => '+263',
        };
    }
}
